/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common;

import com.stackify.api.EnvironmentDetail;
import java.net.InetAddress;

public class EnvironmentDetails {
    public static EnvironmentDetail getEnvironmentDetail(String application, String environment) {
        String hostName = EnvironmentDetails.getHostName();
        String currentPath = System.getProperty("user.dir");
        EnvironmentDetail.Builder environmentBuilder = EnvironmentDetail.newBuilder();
        environmentBuilder.deviceName(hostName);
        environmentBuilder.appLocation(currentPath);
        environmentBuilder.configuredAppName(application);
        environmentBuilder.configuredEnvironmentName(environment);
        return environmentBuilder.build();
    }

    private static String getHostName() {
        try {
            String hostName = System.getenv("HOSTNAME");
            if (hostName != null && 0 < hostName.length()) {
                return hostName;
            }
        }
        catch (Throwable hostName) {
            // empty catch block
        }
        try {
            InetAddress addr = InetAddress.getLocalHost();
            String hostName = addr.getHostName();
            if (hostName != null && 0 < hostName.length()) {
                return hostName;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private EnvironmentDetails() {
    }
}

