/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common;

import com.stackify.api.common.ApiConfiguration;
import com.stackify.api.common.EnvironmentDetails;
import com.stackify.api.common.util.PropertyUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiConfigurations {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiConfigurations.class);

    public static ApiConfiguration fromPropertiesWithOverrides(String apiUrl, String apiKey, String application, String environment) {
        return ApiConfigurations.fromPropertiesWithOverrides(apiUrl, apiKey, application, environment, null);
    }

    public static ApiConfiguration fromPropertiesWithOverrides(String apiUrl, String apiKey, String application, String environment, String allowComDotStackify) {
        ApiConfiguration props = ApiConfigurations.fromProperties();
        String mergedApiUrl = apiUrl != null && 0 < apiUrl.length() ? apiUrl : props.getApiUrl();
        String mergedApiKey = apiKey != null && 0 < apiKey.length() ? apiKey : props.getApiKey();
        String mergedApplication = application != null && 0 < application.length() ? application : props.getApplication();
        String mergedEnvironment = environment != null && 0 < environment.length() ? environment : props.getEnvironment();
        ApiConfiguration.Builder builder = ApiConfiguration.newBuilder();
        builder.apiUrl(mergedApiUrl);
        builder.apiKey(mergedApiKey);
        builder.application(mergedApplication);
        builder.environment(mergedEnvironment);
        builder.envDetail(EnvironmentDetails.getEnvironmentDetail(mergedApplication, mergedEnvironment));
        builder.allowComDotStackify(Boolean.valueOf(allowComDotStackify));
        return builder.build();
    }

    public static ApiConfiguration fromProperties() {
        ApiConfiguration.Builder builder = ApiConfiguration.newBuilder();
        try {
            Map<String, String> properties = PropertyUtil.read("/stackify-api.properties");
            String apiUrl = null;
            if (properties.containsKey("stackify.apiUrl")) {
                apiUrl = properties.get("stackify.apiUrl");
            }
            String httpProxyHost = properties.get("stackify.httpProxyHost");
            String httpProxyPort = properties.get("stackify.httpProxyPort");
            String apiKey = properties.get("stackify.apiKey");
            String application = properties.get("stackify.application");
            String environment = properties.get("stackify.environment");
            boolean skipJson = false;
            if (properties.containsKey("stackify.skipJson")) {
                skipJson = Boolean.parseBoolean(properties.get("stackify.skipJson"));
            }
            builder.httpProxyHost(httpProxyHost);
            builder.httpProxyPort(httpProxyPort);
            builder.apiUrl(apiUrl);
            builder.apiKey(apiKey);
            builder.application(application);
            builder.environment(environment);
            builder.envDetail(EnvironmentDetails.getEnvironmentDetail(application, environment));
            builder.skipJson(skipJson);
        }
        catch (Throwable t) {
            LOGGER.error("Exception reading stackify-api.properties configuration file", t);
        }
        return builder.build();
    }

    private ApiConfigurations() {
    }
}

