/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackify.api.TraceFrame;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ErrorItem {
    @JsonProperty(value="Message")
    private String message;
    @JsonProperty(value="ErrorType")
    private String errorType;
    @JsonProperty(value="ErrorTypeCode")
    private String errorTypeCode;
    @JsonProperty(value="Data")
    private Map<String, String> data;
    @JsonProperty(value="SourceMethod")
    private String sourceMethod;
    @JsonProperty(value="StackTrace")
    private List<TraceFrame> stackTrace;
    @JsonProperty(value="InnerError")
    private ErrorItem innerError;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().message(this.message).errorType(this.errorType).errorTypeCode(this.errorTypeCode).data(this.data).sourceMethod(this.sourceMethod).stackTrace(this.stackTrace).innerError(this.innerError);
    }

    public ErrorItem(String message, String errorType, String errorTypeCode, Map<String, String> data, String sourceMethod, List<TraceFrame> stackTrace, ErrorItem innerError) {
        this.message = message;
        this.errorType = errorType;
        this.errorTypeCode = errorTypeCode;
        this.data = data;
        this.sourceMethod = sourceMethod;
        this.stackTrace = stackTrace;
        this.innerError = innerError;
    }

    public ErrorItem() {
    }

    public String getMessage() {
        return this.message;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public String getErrorTypeCode() {
        return this.errorTypeCode;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public String getSourceMethod() {
        return this.sourceMethod;
    }

    public List<TraceFrame> getStackTrace() {
        return this.stackTrace;
    }

    public ErrorItem getInnerError() {
        return this.innerError;
    }

    @JsonProperty(value="ErrorType")
    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    @JsonProperty(value="ErrorTypeCode")
    public void setErrorTypeCode(String errorTypeCode) {
        this.errorTypeCode = errorTypeCode;
    }

    @JsonProperty(value="Data")
    public void setData(Map<String, String> data) {
        this.data = data;
    }

    @JsonProperty(value="SourceMethod")
    public void setSourceMethod(String sourceMethod) {
        this.sourceMethod = sourceMethod;
    }

    @JsonProperty(value="StackTrace")
    public void setStackTrace(List<TraceFrame> stackTrace) {
        this.stackTrace = stackTrace;
    }

    @JsonProperty(value="InnerError")
    public void setInnerError(ErrorItem innerError) {
        this.innerError = innerError;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrorItem)) {
            return false;
        }
        ErrorItem other = (ErrorItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$errorType = this.getErrorType();
        String other$errorType = other.getErrorType();
        if (this$errorType == null ? other$errorType != null : !this$errorType.equals(other$errorType)) {
            return false;
        }
        String this$errorTypeCode = this.getErrorTypeCode();
        String other$errorTypeCode = other.getErrorTypeCode();
        if (this$errorTypeCode == null ? other$errorTypeCode != null : !this$errorTypeCode.equals(other$errorTypeCode)) {
            return false;
        }
        Map<String, String> this$data = this.getData();
        Map<String, String> other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        String this$sourceMethod = this.getSourceMethod();
        String other$sourceMethod = other.getSourceMethod();
        if (this$sourceMethod == null ? other$sourceMethod != null : !this$sourceMethod.equals(other$sourceMethod)) {
            return false;
        }
        List<TraceFrame> this$stackTrace = this.getStackTrace();
        List<TraceFrame> other$stackTrace = other.getStackTrace();
        if (this$stackTrace == null ? other$stackTrace != null : !((Object)this$stackTrace).equals(other$stackTrace)) {
            return false;
        }
        ErrorItem this$innerError = this.getInnerError();
        ErrorItem other$innerError = other.getInnerError();
        return !(this$innerError == null ? other$innerError != null : !((Object)this$innerError).equals(other$innerError));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ErrorItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $errorType = this.getErrorType();
        result = result * 59 + ($errorType == null ? 43 : $errorType.hashCode());
        String $errorTypeCode = this.getErrorTypeCode();
        result = result * 59 + ($errorTypeCode == null ? 43 : $errorTypeCode.hashCode());
        Map<String, String> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        String $sourceMethod = this.getSourceMethod();
        result = result * 59 + ($sourceMethod == null ? 43 : $sourceMethod.hashCode());
        List<TraceFrame> $stackTrace = this.getStackTrace();
        result = result * 59 + ($stackTrace == null ? 43 : ((Object)$stackTrace).hashCode());
        ErrorItem $innerError = this.getInnerError();
        result = result * 59 + ($innerError == null ? 43 : ((Object)$innerError).hashCode());
        return result;
    }

    public String toString() {
        return "ErrorItem(message=" + this.getMessage() + ", errorType=" + this.getErrorType() + ", errorTypeCode=" + this.getErrorTypeCode() + ", data=" + this.getData() + ", sourceMethod=" + this.getSourceMethod() + ", stackTrace=" + this.getStackTrace() + ", innerError=" + this.getInnerError() + ")";
    }

    @JsonProperty(value="Message")
    public void setMessage(String message) {
        this.message = message;
    }

    public static class Builder {
        private String message;
        private String errorType;
        private String errorTypeCode;
        private Map<String, String> data;
        private String sourceMethod;
        private List<TraceFrame> stackTrace;
        private ErrorItem innerError;

        Builder() {
        }

        @JsonProperty(value="Message")
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @JsonProperty(value="ErrorType")
        public Builder errorType(String errorType) {
            this.errorType = errorType;
            return this;
        }

        @JsonProperty(value="ErrorTypeCode")
        public Builder errorTypeCode(String errorTypeCode) {
            this.errorTypeCode = errorTypeCode;
            return this;
        }

        @JsonProperty(value="Data")
        public Builder data(Map<String, String> data) {
            this.data = data;
            return this;
        }

        @JsonProperty(value="SourceMethod")
        public Builder sourceMethod(String sourceMethod) {
            this.sourceMethod = sourceMethod;
            return this;
        }

        @JsonProperty(value="StackTrace")
        public Builder stackTrace(List<TraceFrame> stackTrace) {
            this.stackTrace = stackTrace;
            return this;
        }

        @JsonProperty(value="InnerError")
        public Builder innerError(ErrorItem innerError) {
            this.innerError = innerError;
            return this;
        }

        public ErrorItem build() {
            return new ErrorItem(this.message, this.errorType, this.errorTypeCode, this.data, this.sourceMethod, this.stackTrace, this.innerError);
        }

        public String toString() {
            return "ErrorItem.Builder(message=" + this.message + ", errorType=" + this.errorType + ", errorTypeCode=" + this.errorTypeCode + ", data=" + this.data + ", sourceMethod=" + this.sourceMethod + ", stackTrace=" + this.stackTrace + ", innerError=" + this.innerError + ")";
        }
    }
}

