/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.log;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.stackify.api.LogMsgGroup;
import com.stackify.api.common.ApiConfiguration;
import com.stackify.api.common.http.HttpClient;
import com.stackify.api.common.log.LogTransport;
import com.stackify.api.common.log.LogTransportAgentSocket;
import com.stackify.api.common.log.LogTransportPreProcessor;
import com.stackify.api.common.mask.Masker;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogTransportDirect
implements LogTransport {
    private static final Logger log = LoggerFactory.getLogger(LogTransportDirect.class);
    private static final String LOG_SAVE_PATH = "/Log/Save";
    private final ApiConfiguration apiConfig;
    private final ObjectMapper objectMapper;
    private final LogTransportPreProcessor logTransportPreProcessor;
    private static final Logger LOGGER = LoggerFactory.getLogger(LogTransportAgentSocket.class);

    public LogTransportDirect(@NonNull ApiConfiguration apiConfig, @NonNull ObjectMapper objectMapper, Masker masker, boolean skipJson) {
        if (apiConfig == null) {
            throw new NullPointerException("apiConfig is marked non-null but is null");
        }
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        this.apiConfig = apiConfig;
        this.objectMapper = objectMapper;
        this.logTransportPreProcessor = new LogTransportPreProcessor(masker, skipJson);
    }

    @Override
    public void send(@NonNull LogMsgGroup group) throws Exception {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        HttpClient httpClient = new HttpClient(this.apiConfig);
        this.logTransportPreProcessor.execute(group);
        byte[] jsonBytes = this.objectMapper.writer().writeValueAsBytes((Object)group);
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("#Log #Transport #Direct Sending request to {} - Body: {}", (Object)LOG_SAVE_PATH, (Object)this.objectMapper.writeValueAsString((Object)group));
            }
            httpClient.post(LOG_SAVE_PATH, jsonBytes, true);
        }
        catch (Exception e) {
            log.info("Queueing logs for retransmission due to Exception");
            log.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

