/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.stackify.api.EnvironmentDetail;
import com.stackify.api.ErrorItem;
import com.stackify.api.WebRequestDetail;
import java.util.Date;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=Builder.class)
public class StackifyError {
    @JsonProperty(value="EnvironmentDetail")
    private final EnvironmentDetail environmentDetail;
    @JsonProperty(value="OccurredEpochMillis")
    private final Date occurredEpochMillis;
    @JsonProperty(value="Error")
    private final ErrorItem error;
    @JsonProperty(value="WebRequestDetail")
    private final WebRequestDetail webRequestDetail;
    @JsonProperty(value="ServerVariables")
    private final Map<String, String> serverVariables;
    @JsonProperty(value="CustomerName")
    private final String customerName;
    @JsonProperty(value="UserName")
    private final String userName;

    public EnvironmentDetail getEnvironmentDetail() {
        return this.environmentDetail;
    }

    public Date getOccurredEpochMillis() {
        return this.occurredEpochMillis;
    }

    public ErrorItem getError() {
        return this.error;
    }

    public WebRequestDetail getWebRequestDetail() {
        return this.webRequestDetail;
    }

    public Map<String, String> getServerVariables() {
        return this.serverVariables;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public String getUserName() {
        return this.userName;
    }

    private StackifyError(Builder builder) {
        this.environmentDetail = builder.environmentDetail;
        this.occurredEpochMillis = builder.occurredEpochMillis;
        this.error = builder.error;
        this.webRequestDetail = builder.webRequestDetail;
        this.serverVariables = builder.serverVariables;
        this.customerName = builder.customerName;
        this.userName = builder.userName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Builder {
        @JsonProperty(value="EnvironmentDetail")
        private EnvironmentDetail environmentDetail;
        @JsonProperty(value="OccurredEpochMillis")
        private Date occurredEpochMillis;
        @JsonProperty(value="Error")
        private ErrorItem error;
        @JsonProperty(value="WebRequestDetail")
        private WebRequestDetail webRequestDetail;
        @JsonProperty(value="ServerVariables")
        private Map<String, String> serverVariables;
        @JsonProperty(value="CustomerName")
        private String customerName;
        @JsonProperty(value="UserName")
        private String userName;

        public Builder environmentDetail(EnvironmentDetail environmentDetail) {
            this.environmentDetail = environmentDetail;
            return this;
        }

        public Builder occurredEpochMillis(Date occurredEpochMillis) {
            this.occurredEpochMillis = occurredEpochMillis;
            return this;
        }

        public Builder error(ErrorItem error) {
            this.error = error;
            return this;
        }

        public Builder webRequestDetail(WebRequestDetail webRequestDetail) {
            this.webRequestDetail = webRequestDetail;
            return this;
        }

        public Builder serverVariables(Map<String, String> serverVariables) {
            this.serverVariables = serverVariables;
            return this;
        }

        public Builder customerName(String customerName) {
            this.customerName = customerName;
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public StackifyError build() {
            return new StackifyError(this);
        }
    }
}

