/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.customcode.dev.test.server;

import java.io.BufferedReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.Request;

public class MockJettyRequest
extends Request {
    private final String methodString;
    private final String uriString;
    private final Map<String, String> headers;
    private final String bodyString;
    private final AtomicBoolean handled = new AtomicBoolean(false);

    public MockJettyRequest(String methodString, String uriString, Map<String, String> headers, String bodyString) {
        this.methodString = methodString;
        this.uriString = uriString;
        this.headers = headers;
        this.bodyString = bodyString;
    }

    public String getMethod() {
        return this.methodString;
    }

    public HttpURI getUri() {
        return new HttpURI(this.uriString);
    }

    public String getPathInfo() {
        try {
            return new URL(this.uriString).getPath();
        }
        catch (MalformedURLException t) {
            return "/";
        }
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.uriString);
    }

    public String getHeader(String headerName) {
        return this.headers.get(headerName);
    }

    public BufferedReader getReader() {
        return new BufferedReader(new StringReader(this.bodyString));
    }

    public Enumeration getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public void setHandled(boolean h) {
        this.handled.set(h);
    }

    public boolean getHandled() {
        return this.handled.get();
    }
}

