/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.stackmob.sdk.api.StackMobSession;
import com.stackmob.sdk.callback.StackMobCallback;
import com.stackmob.sdk.callback.StackMobRedirectedCallback;
import com.stackmob.sdk.exception.StackMobException;
import com.stackmob.sdk.net.HttpRedirectHelper;
import com.stackmob.sdk.net.HttpVerb;
import com.stackmob.sdk.net.StackMobApi;
import com.stackmob.sdk.push.StackMobPushToken;
import com.stackmob.sdk.push.StackMobPushTokenDeserializer;
import com.stackmob.sdk.push.StackMobPushTokenSerializer;
import com.stackmob.sdk.util.Pair;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.scribe.builder.ServiceBuilder;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.oauth.OAuthService;

public class StackMobRequest {
    public static final String DEFAULT_URL_FORMAT = "api.mob1.stackmob.com";
    protected static final String SECURE_SCHEME = "https";
    protected static final String REGULAR_SCHEME = "http";
    protected final StackMobSession session;
    protected final String sessionKey;
    protected final StackMobRedirectedCallback redirectedCallback;
    protected final String sessionSecret;
    protected String methodName;
    protected String urlFormat = "api.mob1.stackmob.com";
    protected Boolean isSecure = false;
    protected HttpVerb httpMethod = HttpVerb.GET;
    protected Map<String, String> params;
    protected Object requestObject;
    protected Gson gson;
    private OAuthService oAuthService;
    protected StackMobCallback callback = new StackMobCallback(){

        @Override
        public void success(String s) {
        }

        @Override
        public void failure(StackMobException e) {
        }
    };

    private StackMobRequest(StackMobSession session, String method, StackMobRedirectedCallback cb) {
        this.session = session;
        this.sessionKey = session.getKey();
        this.sessionSecret = session.getSecret();
        this.methodName = method;
        this.redirectedCallback = cb;
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(StackMobPushToken.class, (Object)new StackMobPushTokenDeserializer()).registerTypeAdapter(StackMobPushToken.class, (Object)new StackMobPushTokenSerializer()).excludeFieldsWithModifiers(new int[]{2, 4, 128, 8});
        this.gson = gsonBuilder.create();
        this.oAuthService = new ServiceBuilder().provider(StackMobApi.class).apiKey(this.sessionKey).apiSecret(this.sessionSecret).build();
    }

    public StackMobRequest(StackMobSession session, String method, StackMobCallback callback, StackMobRedirectedCallback redirCB) {
        this(session, method, redirCB);
        this.callback = callback;
    }

    public StackMobRequest(StackMobSession session, String method, Map<String, String> args, StackMobCallback callback, StackMobRedirectedCallback redirCB) {
        this(session, method, callback, redirCB);
        this.params = args;
    }

    public StackMobRequest(StackMobSession session, String method, HttpVerb verb, Object requestObject, StackMobCallback callback, StackMobRedirectedCallback redirCB) {
        this(session, method, verb, callback, redirCB);
        this.requestObject = requestObject;
    }

    public StackMobRequest(StackMobSession session, String method, HttpVerb verb, StackMobCallback callback, StackMobRedirectedCallback redirCB) {
        this(session, method, callback, redirCB);
        this.methodName = method;
        this.httpMethod = verb;
    }

    public StackMobRequest setUrlFormat(String urlFmt) {
        this.urlFormat = urlFmt;
        return this;
    }

    public void sendRequest() {
        try {
            String response = null;
            switch (this.httpMethod) {
                case GET: {
                    response = this.sendGetRequest();
                    break;
                }
                case POST: {
                    response = this.sendPostRequest();
                    break;
                }
                case PUT: {
                    response = this.sendPutRequest();
                    break;
                }
                case DELETE: {
                    response = this.sendDeleteRequest();
                }
            }
            this.callback.success(response);
        }
        catch (StackMobException e) {
            this.callback.failure(e);
        }
    }

    private String sendGetRequest() throws StackMobException {
        try {
            String query = null;
            if (null != this.params) {
                query = this.formatQueryString(this.getParamsForRequest());
            }
            URI uri = this.createURI(this.getScheme(), this.getHost(), this.getPath(), query);
            OAuthRequest req = this.getOAuthRequest(HttpVerb.GET, uri.toString());
            return this.sendRequest(req);
        }
        catch (URISyntaxException e) {
            throw new StackMobException(e.getMessage());
        }
    }

    private String sendPostRequest() throws StackMobException {
        try {
            URI uri = this.createURI(this.getScheme(), this.getHost(), this.getPath(), "");
            String payload = this.getPayload();
            OAuthRequest req = this.getOAuthRequest(HttpVerb.POST, uri.toString(), payload);
            return this.sendRequest(req);
        }
        catch (URISyntaxException e) {
            throw new StackMobException(e.getMessage());
        }
    }

    private String sendPutRequest() throws StackMobException {
        try {
            URI uri = this.createURI(this.getScheme(), this.getHost(), this.getPath(), "");
            String payload = this.getPayload();
            OAuthRequest req = this.getOAuthRequest(HttpVerb.PUT, uri.toString(), payload);
            return this.sendRequest(req);
        }
        catch (URISyntaxException e) {
            throw new StackMobException(e.getMessage());
        }
    }

    private String sendDeleteRequest() throws StackMobException {
        try {
            String query = null;
            if (null != this.params) {
                query = this.formatQueryString(this.getParamsForRequest());
            }
            URI uri = this.createURI(this.getScheme(), this.getHost(), this.getPath(), query);
            OAuthRequest req = this.getOAuthRequest(HttpVerb.DELETE, uri.toString());
            return this.sendRequest(req);
        }
        catch (URISyntaxException e) {
            throw new StackMobException(e.getMessage());
        }
    }

    private URI createURI(String scheme, String host, String path, String query) throws URISyntaxException {
        StringBuilder uriBuilder = new StringBuilder().append(scheme).append("://").append(host);
        if (!path.startsWith("/")) {
            uriBuilder.append("/");
        }
        uriBuilder.append(path);
        if (query != null && query.length() > 0) {
            uriBuilder.append("?").append(query);
        }
        return new URI(uriBuilder.toString());
    }

    protected String getPath() {
        if (this.methodName.startsWith("/")) {
            return this.methodName;
        }
        return "/" + this.methodName;
    }

    private String getScheme() {
        if (this.isSecure.booleanValue()) {
            return SECURE_SCHEME;
        }
        return REGULAR_SCHEME;
    }

    private String getHost() {
        return this.urlFormat;
    }

    private String percentEncode(String s) throws UnsupportedEncodingException {
        return URLEncoder.encode(s, "UTF-8").replace("+", "%20");
    }

    private String formatQueryString(Map<String, String> params) {
        StringBuilder formatBuilder = new StringBuilder();
        boolean first = true;
        for (String key : params.keySet()) {
            if (!first) {
                formatBuilder.append("&");
            }
            first = false;
            String value = params.get(key);
            try {
                formatBuilder.append(this.percentEncode(key)).append("=").append(this.percentEncode(value));
            }
            catch (UnsupportedEncodingException e) {}
        }
        return formatBuilder.toString();
    }

    private Map<String, String> getParamsForRequest() {
        Map<String, String> ret = new HashMap<String, String>();
        if (null != this.params) {
            ret = this.params;
        }
        return ret;
    }

    private String getPayload() {
        String payload = "";
        if (null != this.params) {
            payload = this.formatQueryString(this.getParamsForRequest());
        } else if (null != this.requestObject) {
            payload = this.gson.toJson(this.requestObject);
        }
        return payload;
    }

    private OAuthRequest getOAuthRequest(HttpVerb method, String url) {
        OAuthRequest oReq = new OAuthRequest(Verb.valueOf((String)method.toString()), url);
        int apiVersion = this.session.getApiVersionNumber();
        String contentType = "application/vnd.stackmob+json;";
        String accept = "application/vnd.stackmob+json; version=" + apiVersion;
        String userAgentIntermediate = "StackMob Java Client; " + apiVersion;
        if (this.session.getAppName() != null) {
            userAgentIntermediate = userAgentIntermediate + "/" + this.session.getAppName();
        }
        String userAgent = userAgentIntermediate;
        ArrayList<Pair<String, String>> headers = new ArrayList<Pair<String, String>>();
        headers.add(new Pair<String, String>("Content-Type", "application/vnd.stackmob+json;"));
        headers.add(new Pair<String, String>("Accept", accept));
        headers.add(new Pair<String, String>("User-Agent", userAgent));
        for (Pair pair : headers) {
            oReq.addHeader((String)pair.getFirst(), (String)pair.getSecond());
        }
        this.oAuthService.signRequest(new Token("", ""), oReq);
        return oReq;
    }

    private OAuthRequest getOAuthRequest(HttpVerb method, String url, String payload) {
        OAuthRequest req = this.getOAuthRequest(method, url);
        req.addPayload(payload);
        return req;
    }

    private String sendRequest(OAuthRequest req) {
        Response ret = req.send();
        if (HttpRedirectHelper.isRedirected(ret.getCode())) {
            try {
                String newLocation = HttpRedirectHelper.getNewLocation(ret.getHeaders());
                HttpVerb verb = HttpVerb.valueOf(req.getVerb().toString());
                OAuthRequest newReq = this.getOAuthRequest(verb, newLocation);
                if (req.getBodyContents() != null && req.getBodyContents().length() > 0) {
                    newReq = this.getOAuthRequest(verb, newLocation, req.getBodyContents());
                }
                this.redirectedCallback.redirected(req.getUrl(), ret.getHeaders(), ret.getBody(), newReq.getUrl());
                return this.sendRequest(newReq);
            }
            catch (Exception e) {
                return ret.getBody();
            }
        }
        return ret.getBody();
    }
}

