/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.api;

import com.stackmob.sdk.util.Pair;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.scribe.model.Response;

public class StackMobCookieStore {
    protected static final String SetCookieHeaderKey = "Set-Cookie";
    protected static final DateFormat cookieDateFormat = new SimpleDateFormat("EEE, dd-MMM-yyyy hh:mm:ss z");
    protected static final String EXPIRES = "Expires";
    protected final ConcurrentHashMap<String, Map.Entry<String, Date>> cookies = new ConcurrentHashMap();

    public void storeCookies(Response resp) {
        this.storeCookie((String)resp.getHeaders().get(SetCookieHeaderKey));
    }

    protected void storeCookie(String cookieString) {
        this.addToCookieMap(this.cookies, cookieString);
    }

    protected void addToCookieMap(Map<String, Map.Entry<String, Date>> map, String cookieString) {
        if (cookieString != null) {
            String[] valSplit = cookieString.split(";");
            if (valSplit.length == 1) {
                String[] cookieSplit = cookieString.split("=");
                if (cookieSplit.length == 2) {
                    map.put(valSplit[0], new Pair<String, Object>(valSplit[1], null));
                }
            } else {
                String[] cookieSplit = valSplit[0].split("=");
                String[] expiresSplit = valSplit[1].split("=");
                Date expires = null;
                if (expiresSplit.length == 2 && cookieSplit.length == 2) {
                    if (expiresSplit[0].equals(EXPIRES)) {
                        try {
                            expires = cookieDateFormat.parse(expiresSplit[1]);
                        }
                        catch (ParseException e) {
                            // empty catch block
                        }
                    }
                    map.put(cookieSplit[0], new Pair<String, Date>(cookieSplit[1], expires));
                }
            }
        }
    }

    protected String cookieMapToHeaderString(Map<String, Map.Entry<String, Date>> map) {
        StringBuilder cookieBuilder = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, Map.Entry<String, Date>> c : this.cookies.entrySet()) {
            if (!this.isUnexpired(c.getValue())) continue;
            if (!first) {
                cookieBuilder.append("; ");
            }
            first = false;
            cookieBuilder.append(c.getKey()).append("=").append(c.getValue().getKey());
        }
        return cookieBuilder.toString();
    }

    private boolean isUnexpired(Map.Entry<String, Date> values) {
        Date expires = values.getValue();
        return expires == null || new Date().compareTo(expires) == 1;
    }

    public void clear() {
        this.cookies.clear();
    }

    public String cookieHeader() {
        return this.cookieMapToHeaderString(this.cookies);
    }
}

