/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.api;

import com.stackmob.sdk.api.StackMob;
import com.stackmob.sdk.util.StackMobCookieManager;
import com.stackmob.sdk.util.StackMobLogger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class StackMobSession {
    private static String SIGNATURE_ALGORITHM = "HmacSHA1";
    private String key;
    private String secret;
    private String userObjectName;
    private String userIdName;
    private int apiVersionNumber;
    private String lastUserLoginName;
    private long serverTimeDiff = 0L;
    private StackMob.OAuthVersion oauthVersion;
    private String oauth2Token;
    private String oauth2MacKey;
    private String oauth2RefreshToken;
    private Date oauth2TokenExpiration;
    private Boolean httpsOverride = null;
    private StackMobCookieManager cookieManager = new StackMobCookieManager();
    private StackMobLogger logger = new StackMobLogger();
    protected String userAgentName = "Java Client";

    public StackMobSession(StackMob.OAuthVersion oauthVersion, int apiVersionNumber, String key, String secret, String userObjectName, String userIdName) {
        this.oauthVersion = oauthVersion;
        this.key = key;
        this.secret = secret;
        this.userObjectName = userObjectName;
        this.userIdName = userIdName;
        this.apiVersionNumber = apiVersionNumber;
    }

    public StackMobSession(StackMobSession that) {
        this.oauthVersion = that.oauthVersion;
        this.key = that.key;
        this.secret = that.secret;
        this.userObjectName = that.userObjectName;
        this.userIdName = that.userIdName;
        this.apiVersionNumber = that.apiVersionNumber;
        this.serverTimeDiff = that.serverTimeDiff;
        this.oauth2Token = that.oauth2Token;
        this.oauth2MacKey = that.oauth2MacKey;
        this.oauth2TokenExpiration = that.oauth2TokenExpiration;
        this.cookieManager = that.cookieManager;
        this.logger = that.logger;
        this.userAgentName = that.userAgentName;
    }

    public String getKey() {
        return this.key;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getUserObjectName() {
        return this.userObjectName;
    }

    public String getUserIdName() {
        return this.userIdName;
    }

    public int getApiVersionNumber() {
        return this.apiVersionNumber;
    }

    protected long getLocalTime() {
        return new Date().getTime() / 1000L;
    }

    public long getServerTime() {
        if (this.getServerTimeDiff() != 0L) {
            this.logger.logDebug("Adjusting time for server by %d seconds", this.getServerTimeDiff());
        }
        return this.getServerTimeDiff() + this.getLocalTime();
    }

    public void recordServerTimeDiff(String timeHeader) {
        this.logger.logDebug("Got a time header of: %s", timeHeader);
        try {
            long serverTime = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz").parse(timeHeader).getTime() / 1000L;
            this.logger.logDebug("Got a server time of %d versus local time %d", serverTime, this.getLocalTime());
            this.saveServerTimeDiff(serverTime - this.getLocalTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void saveServerTimeDiff(long serverTimeDiff) {
        this.serverTimeDiff = serverTimeDiff;
    }

    protected long getServerTimeDiff() {
        return this.serverTimeDiff;
    }

    public void setLastUserLoginName(String username) {
        this.lastUserLoginName = username;
    }

    public String getLastUserLoginName() {
        return this.lastUserLoginName;
    }

    public void setEnableHTTPS(boolean enableHTTPS) {
        this.httpsOverride = enableHTTPS;
    }

    public void setHTTPSOverride(Boolean enableHTTPS) {
        this.httpsOverride = enableHTTPS;
    }

    public Boolean getHTTPSOverride() {
        return this.httpsOverride;
    }

    public StackMob.OAuthVersion getOAuthVersion() {
        return this.oauthVersion;
    }

    public void setOAuthVersion(StackMob.OAuthVersion oauthVersion) {
        this.oauthVersion = oauthVersion;
    }

    public boolean isOAuth2() {
        return this.oauthVersion == StackMob.OAuthVersion.Two;
    }

    public void setOAuth2TokensAndExpiration(String accessToken, String macKey, String refreshToken, int seconds) {
        this.setOAuth2TokensAndExpiration(accessToken, macKey, refreshToken, new Date(new Date().getTime() + (long)(seconds * 1000)));
    }

    protected void setOAuth2TokensAndExpiration(String accessToken, String macKey, String refreshToken, Date expiration) {
        this.oauth2Token = accessToken;
        this.oauth2MacKey = macKey;
        this.oauth2RefreshToken = refreshToken;
        this.oauth2TokenExpiration = expiration;
    }

    public Date getOAuth2TokenExpiration() {
        return this.oauth2TokenExpiration;
    }

    public boolean oauth2TokenValid() {
        return this.oauth2TokenExpiration != null && this.oauth2TokenExpiration.after(new Date());
    }

    public boolean oauth2RefreshTokenValid() {
        return this.oauth2RefreshToken != null;
    }

    public String getOAuth2RefreshToken() {
        return this.oauth2RefreshToken;
    }

    public void setCookieManager(StackMobCookieManager store) {
        this.cookieManager = store;
    }

    public StackMobCookieManager getCookieManager() {
        return this.cookieManager;
    }

    public void setLogger(StackMobLogger logger) {
        this.logger = logger;
    }

    public StackMobLogger getLogger() {
        return this.logger;
    }

    public String getUserAgent() {
        return String.format("StackMob (%s; %s)", this.userAgentName, StackMob.getVersion());
    }

    public String generateMacToken(String method, String uri, String host, String port) {
        String ts = String.valueOf(new Date().getTime() / 1000L);
        String nonce = String.format("n%d", Math.round(Math.random() * 10000.0));
        try {
            String baseString = this.getNormalizedRequestString(ts, nonce, method, uri, host, port);
            Mac mac = Mac.getInstance(SIGNATURE_ALGORITHM);
            SecretKeySpec spec = new SecretKeySpec(this.oauth2MacKey.getBytes(), SIGNATURE_ALGORITHM);
            try {
                mac.init(spec);
            }
            catch (InvalidKeyException ike) {
                throw new IllegalStateException(ike);
            }
            byte[] rawMacBytes = mac.doFinal(baseString.getBytes());
            byte[] b64Bytes = Base64.encodeBase64((byte[])rawMacBytes);
            String calculatedMac = new String(b64Bytes);
            return String.format("MAC id=\"%s\",ts=\"%s\",nonce=\"%s\",mac=\"%s\"", this.oauth2Token, ts, nonce, calculatedMac);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("This device doesn't have SHA1");
        }
    }

    private String getNormalizedRequestString(String timestamp, String nonce, String method, String uri, String host, String port) {
        return timestamp + "\n" + nonce + "\n" + method + "\n" + uri + "\n" + host + "\n" + port + "\n\n";
    }
}

