/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AtsMoveApplicationRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Objects;

public class AtsMoveApplicationRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private AtsMoveApplicationRequestDto atsMoveApplicationRequestDto;

    @JsonCreator
    public AtsMoveApplicationRequest(String xAccountId, String id, AtsMoveApplicationRequestDto atsMoveApplicationRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(atsMoveApplicationRequestDto, "atsMoveApplicationRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.atsMoveApplicationRequestDto = atsMoveApplicationRequestDto;
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public AtsMoveApplicationRequestDto atsMoveApplicationRequestDto() {
        return this.atsMoveApplicationRequestDto;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public AtsMoveApplicationRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsMoveApplicationRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public AtsMoveApplicationRequest withAtsMoveApplicationRequestDto(AtsMoveApplicationRequestDto atsMoveApplicationRequestDto) {
        Utils.checkNotNull(atsMoveApplicationRequestDto, "atsMoveApplicationRequestDto");
        this.atsMoveApplicationRequestDto = atsMoveApplicationRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsMoveApplicationRequest other = (AtsMoveApplicationRequest)o;
        return Objects.deepEquals(this.xAccountId, other.xAccountId) && Objects.deepEquals(this.id, other.id) && Objects.deepEquals(this.atsMoveApplicationRequestDto, other.atsMoveApplicationRequestDto);
    }

    public int hashCode() {
        return Objects.hash(this.xAccountId, this.id, this.atsMoveApplicationRequestDto);
    }

    public String toString() {
        return Utils.toString(AtsMoveApplicationRequest.class, "xAccountId", this.xAccountId, "id", this.id, "atsMoveApplicationRequestDto", this.atsMoveApplicationRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private String id;
        private AtsMoveApplicationRequestDto atsMoveApplicationRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder atsMoveApplicationRequestDto(AtsMoveApplicationRequestDto atsMoveApplicationRequestDto) {
            Utils.checkNotNull(atsMoveApplicationRequestDto, "atsMoveApplicationRequestDto");
            this.atsMoveApplicationRequestDto = atsMoveApplicationRequestDto;
            return this;
        }

        public AtsMoveApplicationRequest build() {
            return new AtsMoveApplicationRequest(this.xAccountId, this.id, this.atsMoveApplicationRequestDto);
        }
    }
}

