/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.WorkEligibilityPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;

public class HrisListEmployeeWorkEligibilityResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends WorkEligibilityPaginated> workEligibilityPaginated;
    private Map<String, List<String>> headers;
    private Callable<Optional<HrisListEmployeeWorkEligibilityResponse>> next = () -> Optional.empty();

    @JsonCreator
    public HrisListEmployeeWorkEligibilityResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends WorkEligibilityPaginated> workEligibilityPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(workEligibilityPaginated, "workEligibilityPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.workEligibilityPaginated = workEligibilityPaginated;
        this.headers = headers;
    }

    public HrisListEmployeeWorkEligibilityResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<WorkEligibilityPaginated> workEligibilityPaginated() {
        return this.workEligibilityPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public Optional<HrisListEmployeeWorkEligibilityResponse> next() throws Exception {
        return this.next.call();
    }

    private HrisListEmployeeWorkEligibilityResponse withNext(Callable<Optional<HrisListEmployeeWorkEligibilityResponse>> next) {
        this.next = next;
        return this;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public HrisListEmployeeWorkEligibilityResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisListEmployeeWorkEligibilityResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisListEmployeeWorkEligibilityResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisListEmployeeWorkEligibilityResponse withWorkEligibilityPaginated(WorkEligibilityPaginated workEligibilityPaginated) {
        Utils.checkNotNull(workEligibilityPaginated, "workEligibilityPaginated");
        this.workEligibilityPaginated = Optional.ofNullable(workEligibilityPaginated);
        return this;
    }

    public HrisListEmployeeWorkEligibilityResponse withWorkEligibilityPaginated(Optional<? extends WorkEligibilityPaginated> workEligibilityPaginated) {
        Utils.checkNotNull(workEligibilityPaginated, "workEligibilityPaginated");
        this.workEligibilityPaginated = workEligibilityPaginated;
        return this;
    }

    public HrisListEmployeeWorkEligibilityResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisListEmployeeWorkEligibilityResponse other = (HrisListEmployeeWorkEligibilityResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.workEligibilityPaginated, other.workEligibilityPaginated) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.workEligibilityPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisListEmployeeWorkEligibilityResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "workEligibilityPaginated", this.workEligibilityPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private Callable<Optional<HrisListEmployeeWorkEligibilityResponse>> next;
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends WorkEligibilityPaginated> workEligibilityPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder workEligibilityPaginated(WorkEligibilityPaginated workEligibilityPaginated) {
            Utils.checkNotNull(workEligibilityPaginated, "workEligibilityPaginated");
            this.workEligibilityPaginated = Optional.ofNullable(workEligibilityPaginated);
            return this;
        }

        public Builder workEligibilityPaginated(Optional<? extends WorkEligibilityPaginated> workEligibilityPaginated) {
            Utils.checkNotNull(workEligibilityPaginated, "workEligibilityPaginated");
            this.workEligibilityPaginated = workEligibilityPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        @Deprecated
        public Builder next(Callable<Optional<HrisListEmployeeWorkEligibilityResponse>> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }

        public HrisListEmployeeWorkEligibilityResponse build() {
            return new HrisListEmployeeWorkEligibilityResponse(this.contentType, this.statusCode, this.rawResponse, this.workEligibilityPaginated, this.headers).withNext(this.next);
        }
    }
}

