/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ATSLocationsPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;

public class AtsListLocationsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends ATSLocationsPaginated> atsLocationsPaginated;
    private Map<String, List<String>> headers;
    private Callable<Optional<AtsListLocationsResponse>> next = () -> Optional.empty();

    @JsonCreator
    public AtsListLocationsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends ATSLocationsPaginated> atsLocationsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(atsLocationsPaginated, "atsLocationsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.atsLocationsPaginated = atsLocationsPaginated;
        this.headers = headers;
    }

    public AtsListLocationsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<ATSLocationsPaginated> atsLocationsPaginated() {
        return this.atsLocationsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public Optional<AtsListLocationsResponse> next() throws Exception {
        return this.next.call();
    }

    private AtsListLocationsResponse withNext(Callable<Optional<AtsListLocationsResponse>> next) {
        this.next = next;
        return this;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public AtsListLocationsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsListLocationsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsListLocationsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsListLocationsResponse withATSLocationsPaginated(ATSLocationsPaginated atsLocationsPaginated) {
        Utils.checkNotNull(atsLocationsPaginated, "atsLocationsPaginated");
        this.atsLocationsPaginated = Optional.ofNullable(atsLocationsPaginated);
        return this;
    }

    public AtsListLocationsResponse withATSLocationsPaginated(Optional<? extends ATSLocationsPaginated> atsLocationsPaginated) {
        Utils.checkNotNull(atsLocationsPaginated, "atsLocationsPaginated");
        this.atsLocationsPaginated = atsLocationsPaginated;
        return this;
    }

    public AtsListLocationsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsListLocationsResponse other = (AtsListLocationsResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.atsLocationsPaginated, other.atsLocationsPaginated) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.atsLocationsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsListLocationsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "atsLocationsPaginated", this.atsLocationsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private Callable<Optional<AtsListLocationsResponse>> next;
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends ATSLocationsPaginated> atsLocationsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder atsLocationsPaginated(ATSLocationsPaginated atsLocationsPaginated) {
            Utils.checkNotNull(atsLocationsPaginated, "atsLocationsPaginated");
            this.atsLocationsPaginated = Optional.ofNullable(atsLocationsPaginated);
            return this;
        }

        public Builder atsLocationsPaginated(Optional<? extends ATSLocationsPaginated> atsLocationsPaginated) {
            Utils.checkNotNull(atsLocationsPaginated, "atsLocationsPaginated");
            this.atsLocationsPaginated = atsLocationsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        @Deprecated
        public Builder next(Callable<Optional<AtsListLocationsResponse>> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }

        public AtsListLocationsResponse build() {
            return new AtsListLocationsResponse(this.contentType, this.statusCode, this.rawResponse, this.atsLocationsPaginated, this.headers).withNext(this.next);
        }
    }
}

