/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class CreateEmploymentApiModel {

    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("unified_custom_fields")
    private JsonNullable<? extends Map<String, Object>> unifiedCustomFields;

    /**
     * The employee ID associated with this employment
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("employee_id")
    private JsonNullable<String> employeeId;

    /**
     * The job title of the employee
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("job_title")
    private JsonNullable<String> jobTitle;

    /**
     * The pay rate for the employee
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("pay_rate")
    private JsonNullable<String> payRate;

    /**
     * The pay period
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("pay_period")
    private JsonNullable<? extends CreateEmploymentApiModelPayPeriod> payPeriod;

    /**
     * The pay frequency
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("pay_frequency")
    private JsonNullable<? extends CreateEmploymentApiModelPayFrequency> payFrequency;

    /**
     * The currency used for pay
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("pay_currency")
    private JsonNullable<String> payCurrency;

    /**
     * The effective date of the employment contract
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("effective_date")
    private JsonNullable<OffsetDateTime> effectiveDate;

    /**
     * The type of employment (e.g., contractor, permanent)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("employment_type")
    private JsonNullable<? extends CreateEmploymentApiModelEmploymentType> employmentType;

    /**
     * The employment work schedule type (e.g., full-time, part-time)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("employment_contract_type")
    private JsonNullable<? extends CreateEmploymentApiModelEmploymentContractType> employmentContractType;

    /**
     * The time worked for the employee in ISO 8601 duration format
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("time_worked")
    private JsonNullable<String> timeWorked;

    @JsonCreator
    public CreateEmploymentApiModel(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("unified_custom_fields") JsonNullable<? extends Map<String, Object>> unifiedCustomFields,
            @JsonProperty("employee_id") JsonNullable<String> employeeId,
            @JsonProperty("job_title") JsonNullable<String> jobTitle,
            @JsonProperty("pay_rate") JsonNullable<String> payRate,
            @JsonProperty("pay_period") JsonNullable<? extends CreateEmploymentApiModelPayPeriod> payPeriod,
            @JsonProperty("pay_frequency") JsonNullable<? extends CreateEmploymentApiModelPayFrequency> payFrequency,
            @JsonProperty("pay_currency") JsonNullable<String> payCurrency,
            @JsonProperty("effective_date") JsonNullable<OffsetDateTime> effectiveDate,
            @JsonProperty("employment_type") JsonNullable<? extends CreateEmploymentApiModelEmploymentType> employmentType,
            @JsonProperty("employment_contract_type") JsonNullable<? extends CreateEmploymentApiModelEmploymentContractType> employmentContractType,
            @JsonProperty("time_worked") JsonNullable<String> timeWorked) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        Utils.checkNotNull(employeeId, "employeeId");
        Utils.checkNotNull(jobTitle, "jobTitle");
        Utils.checkNotNull(payRate, "payRate");
        Utils.checkNotNull(payPeriod, "payPeriod");
        Utils.checkNotNull(payFrequency, "payFrequency");
        Utils.checkNotNull(payCurrency, "payCurrency");
        Utils.checkNotNull(effectiveDate, "effectiveDate");
        Utils.checkNotNull(employmentType, "employmentType");
        Utils.checkNotNull(employmentContractType, "employmentContractType");
        Utils.checkNotNull(timeWorked, "timeWorked");
        this.id = id;
        this.unifiedCustomFields = unifiedCustomFields;
        this.employeeId = employeeId;
        this.jobTitle = jobTitle;
        this.payRate = payRate;
        this.payPeriod = payPeriod;
        this.payFrequency = payFrequency;
        this.payCurrency = payCurrency;
        this.effectiveDate = effectiveDate;
        this.employmentType = employmentType;
        this.employmentContractType = employmentContractType;
        this.timeWorked = timeWorked;
    }
    
    public CreateEmploymentApiModel() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> unifiedCustomFields() {
        return (JsonNullable<Map<String, Object>>) unifiedCustomFields;
    }

    /**
     * The employee ID associated with this employment
     */
    @JsonIgnore
    public JsonNullable<String> employeeId() {
        return employeeId;
    }

    /**
     * The job title of the employee
     */
    @JsonIgnore
    public JsonNullable<String> jobTitle() {
        return jobTitle;
    }

    /**
     * The pay rate for the employee
     */
    @JsonIgnore
    public JsonNullable<String> payRate() {
        return payRate;
    }

    /**
     * The pay period
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<CreateEmploymentApiModelPayPeriod> payPeriod() {
        return (JsonNullable<CreateEmploymentApiModelPayPeriod>) payPeriod;
    }

    /**
     * The pay frequency
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<CreateEmploymentApiModelPayFrequency> payFrequency() {
        return (JsonNullable<CreateEmploymentApiModelPayFrequency>) payFrequency;
    }

    /**
     * The currency used for pay
     */
    @JsonIgnore
    public JsonNullable<String> payCurrency() {
        return payCurrency;
    }

    /**
     * The effective date of the employment contract
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> effectiveDate() {
        return effectiveDate;
    }

    /**
     * The type of employment (e.g., contractor, permanent)
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<CreateEmploymentApiModelEmploymentType> employmentType() {
        return (JsonNullable<CreateEmploymentApiModelEmploymentType>) employmentType;
    }

    /**
     * The employment work schedule type (e.g., full-time, part-time)
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<CreateEmploymentApiModelEmploymentContractType> employmentContractType() {
        return (JsonNullable<CreateEmploymentApiModelEmploymentContractType>) employmentContractType;
    }

    /**
     * The time worked for the employee in ISO 8601 duration format
     */
    @JsonIgnore
    public JsonNullable<String> timeWorked() {
        return timeWorked;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * Unique identifier
     */
    public CreateEmploymentApiModel withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public CreateEmploymentApiModel withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public CreateEmploymentApiModel withUnifiedCustomFields(Map<String, Object> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public CreateEmploymentApiModel withUnifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = unifiedCustomFields;
        return this;
    }

    /**
     * The employee ID associated with this employment
     */
    public CreateEmploymentApiModel withEmployeeId(String employeeId) {
        Utils.checkNotNull(employeeId, "employeeId");
        this.employeeId = JsonNullable.of(employeeId);
        return this;
    }

    /**
     * The employee ID associated with this employment
     */
    public CreateEmploymentApiModel withEmployeeId(JsonNullable<String> employeeId) {
        Utils.checkNotNull(employeeId, "employeeId");
        this.employeeId = employeeId;
        return this;
    }

    /**
     * The job title of the employee
     */
    public CreateEmploymentApiModel withJobTitle(String jobTitle) {
        Utils.checkNotNull(jobTitle, "jobTitle");
        this.jobTitle = JsonNullable.of(jobTitle);
        return this;
    }

    /**
     * The job title of the employee
     */
    public CreateEmploymentApiModel withJobTitle(JsonNullable<String> jobTitle) {
        Utils.checkNotNull(jobTitle, "jobTitle");
        this.jobTitle = jobTitle;
        return this;
    }

    /**
     * The pay rate for the employee
     */
    public CreateEmploymentApiModel withPayRate(String payRate) {
        Utils.checkNotNull(payRate, "payRate");
        this.payRate = JsonNullable.of(payRate);
        return this;
    }

    /**
     * The pay rate for the employee
     */
    public CreateEmploymentApiModel withPayRate(JsonNullable<String> payRate) {
        Utils.checkNotNull(payRate, "payRate");
        this.payRate = payRate;
        return this;
    }

    /**
     * The pay period
     */
    public CreateEmploymentApiModel withPayPeriod(CreateEmploymentApiModelPayPeriod payPeriod) {
        Utils.checkNotNull(payPeriod, "payPeriod");
        this.payPeriod = JsonNullable.of(payPeriod);
        return this;
    }

    /**
     * The pay period
     */
    public CreateEmploymentApiModel withPayPeriod(JsonNullable<? extends CreateEmploymentApiModelPayPeriod> payPeriod) {
        Utils.checkNotNull(payPeriod, "payPeriod");
        this.payPeriod = payPeriod;
        return this;
    }

    /**
     * The pay frequency
     */
    public CreateEmploymentApiModel withPayFrequency(CreateEmploymentApiModelPayFrequency payFrequency) {
        Utils.checkNotNull(payFrequency, "payFrequency");
        this.payFrequency = JsonNullable.of(payFrequency);
        return this;
    }

    /**
     * The pay frequency
     */
    public CreateEmploymentApiModel withPayFrequency(JsonNullable<? extends CreateEmploymentApiModelPayFrequency> payFrequency) {
        Utils.checkNotNull(payFrequency, "payFrequency");
        this.payFrequency = payFrequency;
        return this;
    }

    /**
     * The currency used for pay
     */
    public CreateEmploymentApiModel withPayCurrency(String payCurrency) {
        Utils.checkNotNull(payCurrency, "payCurrency");
        this.payCurrency = JsonNullable.of(payCurrency);
        return this;
    }

    /**
     * The currency used for pay
     */
    public CreateEmploymentApiModel withPayCurrency(JsonNullable<String> payCurrency) {
        Utils.checkNotNull(payCurrency, "payCurrency");
        this.payCurrency = payCurrency;
        return this;
    }

    /**
     * The effective date of the employment contract
     */
    public CreateEmploymentApiModel withEffectiveDate(OffsetDateTime effectiveDate) {
        Utils.checkNotNull(effectiveDate, "effectiveDate");
        this.effectiveDate = JsonNullable.of(effectiveDate);
        return this;
    }

    /**
     * The effective date of the employment contract
     */
    public CreateEmploymentApiModel withEffectiveDate(JsonNullable<OffsetDateTime> effectiveDate) {
        Utils.checkNotNull(effectiveDate, "effectiveDate");
        this.effectiveDate = effectiveDate;
        return this;
    }

    /**
     * The type of employment (e.g., contractor, permanent)
     */
    public CreateEmploymentApiModel withEmploymentType(CreateEmploymentApiModelEmploymentType employmentType) {
        Utils.checkNotNull(employmentType, "employmentType");
        this.employmentType = JsonNullable.of(employmentType);
        return this;
    }

    /**
     * The type of employment (e.g., contractor, permanent)
     */
    public CreateEmploymentApiModel withEmploymentType(JsonNullable<? extends CreateEmploymentApiModelEmploymentType> employmentType) {
        Utils.checkNotNull(employmentType, "employmentType");
        this.employmentType = employmentType;
        return this;
    }

    /**
     * The employment work schedule type (e.g., full-time, part-time)
     */
    public CreateEmploymentApiModel withEmploymentContractType(CreateEmploymentApiModelEmploymentContractType employmentContractType) {
        Utils.checkNotNull(employmentContractType, "employmentContractType");
        this.employmentContractType = JsonNullable.of(employmentContractType);
        return this;
    }

    /**
     * The employment work schedule type (e.g., full-time, part-time)
     */
    public CreateEmploymentApiModel withEmploymentContractType(JsonNullable<? extends CreateEmploymentApiModelEmploymentContractType> employmentContractType) {
        Utils.checkNotNull(employmentContractType, "employmentContractType");
        this.employmentContractType = employmentContractType;
        return this;
    }

    /**
     * The time worked for the employee in ISO 8601 duration format
     */
    public CreateEmploymentApiModel withTimeWorked(String timeWorked) {
        Utils.checkNotNull(timeWorked, "timeWorked");
        this.timeWorked = JsonNullable.of(timeWorked);
        return this;
    }

    /**
     * The time worked for the employee in ISO 8601 duration format
     */
    public CreateEmploymentApiModel withTimeWorked(JsonNullable<String> timeWorked) {
        Utils.checkNotNull(timeWorked, "timeWorked");
        this.timeWorked = timeWorked;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateEmploymentApiModel other = (CreateEmploymentApiModel) o;
        return 
            Objects.deepEquals(this.id, other.id) &&
            Objects.deepEquals(this.unifiedCustomFields, other.unifiedCustomFields) &&
            Objects.deepEquals(this.employeeId, other.employeeId) &&
            Objects.deepEquals(this.jobTitle, other.jobTitle) &&
            Objects.deepEquals(this.payRate, other.payRate) &&
            Objects.deepEquals(this.payPeriod, other.payPeriod) &&
            Objects.deepEquals(this.payFrequency, other.payFrequency) &&
            Objects.deepEquals(this.payCurrency, other.payCurrency) &&
            Objects.deepEquals(this.effectiveDate, other.effectiveDate) &&
            Objects.deepEquals(this.employmentType, other.employmentType) &&
            Objects.deepEquals(this.employmentContractType, other.employmentContractType) &&
            Objects.deepEquals(this.timeWorked, other.timeWorked);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            id,
            unifiedCustomFields,
            employeeId,
            jobTitle,
            payRate,
            payPeriod,
            payFrequency,
            payCurrency,
            effectiveDate,
            employmentType,
            employmentContractType,
            timeWorked);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateEmploymentApiModel.class,
                "id", id,
                "unifiedCustomFields", unifiedCustomFields,
                "employeeId", employeeId,
                "jobTitle", jobTitle,
                "payRate", payRate,
                "payPeriod", payPeriod,
                "payFrequency", payFrequency,
                "payCurrency", payCurrency,
                "effectiveDate", effectiveDate,
                "employmentType", employmentType,
                "employmentContractType", employmentContractType,
                "timeWorked", timeWorked);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> id = JsonNullable.undefined();
 
        private JsonNullable<? extends Map<String, Object>> unifiedCustomFields = JsonNullable.undefined();
 
        private JsonNullable<String> employeeId = JsonNullable.undefined();
 
        private JsonNullable<String> jobTitle = JsonNullable.undefined();
 
        private JsonNullable<String> payRate = JsonNullable.undefined();
 
        private JsonNullable<? extends CreateEmploymentApiModelPayPeriod> payPeriod = JsonNullable.undefined();
 
        private JsonNullable<? extends CreateEmploymentApiModelPayFrequency> payFrequency = JsonNullable.undefined();
 
        private JsonNullable<String> payCurrency = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> effectiveDate = JsonNullable.undefined();
 
        private JsonNullable<? extends CreateEmploymentApiModelEmploymentType> employmentType = JsonNullable.undefined();
 
        private JsonNullable<? extends CreateEmploymentApiModelEmploymentContractType> employmentContractType = JsonNullable.undefined();
 
        private JsonNullable<String> timeWorked = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(Map<String, Object> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
            return this;
        }

        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = unifiedCustomFields;
            return this;
        }

        /**
         * The employee ID associated with this employment
         */
        public Builder employeeId(String employeeId) {
            Utils.checkNotNull(employeeId, "employeeId");
            this.employeeId = JsonNullable.of(employeeId);
            return this;
        }

        /**
         * The employee ID associated with this employment
         */
        public Builder employeeId(JsonNullable<String> employeeId) {
            Utils.checkNotNull(employeeId, "employeeId");
            this.employeeId = employeeId;
            return this;
        }

        /**
         * The job title of the employee
         */
        public Builder jobTitle(String jobTitle) {
            Utils.checkNotNull(jobTitle, "jobTitle");
            this.jobTitle = JsonNullable.of(jobTitle);
            return this;
        }

        /**
         * The job title of the employee
         */
        public Builder jobTitle(JsonNullable<String> jobTitle) {
            Utils.checkNotNull(jobTitle, "jobTitle");
            this.jobTitle = jobTitle;
            return this;
        }

        /**
         * The pay rate for the employee
         */
        public Builder payRate(String payRate) {
            Utils.checkNotNull(payRate, "payRate");
            this.payRate = JsonNullable.of(payRate);
            return this;
        }

        /**
         * The pay rate for the employee
         */
        public Builder payRate(JsonNullable<String> payRate) {
            Utils.checkNotNull(payRate, "payRate");
            this.payRate = payRate;
            return this;
        }

        /**
         * The pay period
         */
        public Builder payPeriod(CreateEmploymentApiModelPayPeriod payPeriod) {
            Utils.checkNotNull(payPeriod, "payPeriod");
            this.payPeriod = JsonNullable.of(payPeriod);
            return this;
        }

        /**
         * The pay period
         */
        public Builder payPeriod(JsonNullable<? extends CreateEmploymentApiModelPayPeriod> payPeriod) {
            Utils.checkNotNull(payPeriod, "payPeriod");
            this.payPeriod = payPeriod;
            return this;
        }

        /**
         * The pay frequency
         */
        public Builder payFrequency(CreateEmploymentApiModelPayFrequency payFrequency) {
            Utils.checkNotNull(payFrequency, "payFrequency");
            this.payFrequency = JsonNullable.of(payFrequency);
            return this;
        }

        /**
         * The pay frequency
         */
        public Builder payFrequency(JsonNullable<? extends CreateEmploymentApiModelPayFrequency> payFrequency) {
            Utils.checkNotNull(payFrequency, "payFrequency");
            this.payFrequency = payFrequency;
            return this;
        }

        /**
         * The currency used for pay
         */
        public Builder payCurrency(String payCurrency) {
            Utils.checkNotNull(payCurrency, "payCurrency");
            this.payCurrency = JsonNullable.of(payCurrency);
            return this;
        }

        /**
         * The currency used for pay
         */
        public Builder payCurrency(JsonNullable<String> payCurrency) {
            Utils.checkNotNull(payCurrency, "payCurrency");
            this.payCurrency = payCurrency;
            return this;
        }

        /**
         * The effective date of the employment contract
         */
        public Builder effectiveDate(OffsetDateTime effectiveDate) {
            Utils.checkNotNull(effectiveDate, "effectiveDate");
            this.effectiveDate = JsonNullable.of(effectiveDate);
            return this;
        }

        /**
         * The effective date of the employment contract
         */
        public Builder effectiveDate(JsonNullable<OffsetDateTime> effectiveDate) {
            Utils.checkNotNull(effectiveDate, "effectiveDate");
            this.effectiveDate = effectiveDate;
            return this;
        }

        /**
         * The type of employment (e.g., contractor, permanent)
         */
        public Builder employmentType(CreateEmploymentApiModelEmploymentType employmentType) {
            Utils.checkNotNull(employmentType, "employmentType");
            this.employmentType = JsonNullable.of(employmentType);
            return this;
        }

        /**
         * The type of employment (e.g., contractor, permanent)
         */
        public Builder employmentType(JsonNullable<? extends CreateEmploymentApiModelEmploymentType> employmentType) {
            Utils.checkNotNull(employmentType, "employmentType");
            this.employmentType = employmentType;
            return this;
        }

        /**
         * The employment work schedule type (e.g., full-time, part-time)
         */
        public Builder employmentContractType(CreateEmploymentApiModelEmploymentContractType employmentContractType) {
            Utils.checkNotNull(employmentContractType, "employmentContractType");
            this.employmentContractType = JsonNullable.of(employmentContractType);
            return this;
        }

        /**
         * The employment work schedule type (e.g., full-time, part-time)
         */
        public Builder employmentContractType(JsonNullable<? extends CreateEmploymentApiModelEmploymentContractType> employmentContractType) {
            Utils.checkNotNull(employmentContractType, "employmentContractType");
            this.employmentContractType = employmentContractType;
            return this;
        }

        /**
         * The time worked for the employee in ISO 8601 duration format
         */
        public Builder timeWorked(String timeWorked) {
            Utils.checkNotNull(timeWorked, "timeWorked");
            this.timeWorked = JsonNullable.of(timeWorked);
            return this;
        }

        /**
         * The time worked for the employee in ISO 8601 duration format
         */
        public Builder timeWorked(JsonNullable<String> timeWorked) {
            Utils.checkNotNull(timeWorked, "timeWorked");
            this.timeWorked = timeWorked;
            return this;
        }
        
        public CreateEmploymentApiModel build() {
            return new CreateEmploymentApiModel(
                id,
                unifiedCustomFields,
                employeeId,
                jobTitle,
                payRate,
                payPeriod,
                payFrequency,
                payCurrency,
                effectiveDate,
                employmentType,
                employmentContractType,
                timeWorked);
        }
    }
}

