/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Boolean;
import java.lang.Deprecated;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class Skills {

    /**
     * The ID associated with this skill
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * The name associated with this skill
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private JsonNullable<String> name;

    /**
     * Whether the skill is active and therefore available for use
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("active")
    private JsonNullable<Boolean> active;

    /**
     * The hierarchal level of the skill
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("hierarchy")
    private JsonNullable<? extends SkillsHierarchy> hierarchy;

    /**
     * The user proficiency level of the skill ranked out of 5
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("proficiency")
    private JsonNullable<? extends Proficiency> proficiency;

    /**
     * The language associated with this skill
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("language")
    private JsonNullable<? extends SkillsLanguage> language;

    /**
     * The hierarchal level of the skill
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("level")
    @Deprecated
    private JsonNullable<? extends SkillsLevel> level;

    @JsonCreator
    public Skills(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("name") JsonNullable<String> name,
            @JsonProperty("active") JsonNullable<Boolean> active,
            @JsonProperty("hierarchy") JsonNullable<? extends SkillsHierarchy> hierarchy,
            @JsonProperty("proficiency") JsonNullable<? extends Proficiency> proficiency,
            @JsonProperty("language") JsonNullable<? extends SkillsLanguage> language,
            @JsonProperty("level") JsonNullable<? extends SkillsLevel> level) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(active, "active");
        Utils.checkNotNull(hierarchy, "hierarchy");
        Utils.checkNotNull(proficiency, "proficiency");
        Utils.checkNotNull(language, "language");
        Utils.checkNotNull(level, "level");
        this.id = id;
        this.remoteId = remoteId;
        this.name = name;
        this.active = active;
        this.hierarchy = hierarchy;
        this.proficiency = proficiency;
        this.language = language;
        this.level = level;
    }
    
    public Skills() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The ID associated with this skill
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * The name associated with this skill
     */
    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    /**
     * Whether the skill is active and therefore available for use
     */
    @JsonIgnore
    public JsonNullable<Boolean> active() {
        return active;
    }

    /**
     * The hierarchal level of the skill
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<SkillsHierarchy> hierarchy() {
        return (JsonNullable<SkillsHierarchy>) hierarchy;
    }

    /**
     * The user proficiency level of the skill ranked out of 5
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Proficiency> proficiency() {
        return (JsonNullable<Proficiency>) proficiency;
    }

    /**
     * The language associated with this skill
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<SkillsLanguage> language() {
        return (JsonNullable<SkillsLanguage>) language;
    }

    /**
     * The hierarchal level of the skill
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<SkillsLevel> level() {
        return (JsonNullable<SkillsLevel>) level;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * The ID associated with this skill
     */
    public Skills withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * The ID associated with this skill
     */
    public Skills withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Skills withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Skills withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * The name associated with this skill
     */
    public Skills withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    /**
     * The name associated with this skill
     */
    public Skills withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * Whether the skill is active and therefore available for use
     */
    public Skills withActive(boolean active) {
        Utils.checkNotNull(active, "active");
        this.active = JsonNullable.of(active);
        return this;
    }

    /**
     * Whether the skill is active and therefore available for use
     */
    public Skills withActive(JsonNullable<Boolean> active) {
        Utils.checkNotNull(active, "active");
        this.active = active;
        return this;
    }

    /**
     * The hierarchal level of the skill
     */
    public Skills withHierarchy(SkillsHierarchy hierarchy) {
        Utils.checkNotNull(hierarchy, "hierarchy");
        this.hierarchy = JsonNullable.of(hierarchy);
        return this;
    }

    /**
     * The hierarchal level of the skill
     */
    public Skills withHierarchy(JsonNullable<? extends SkillsHierarchy> hierarchy) {
        Utils.checkNotNull(hierarchy, "hierarchy");
        this.hierarchy = hierarchy;
        return this;
    }

    /**
     * The user proficiency level of the skill ranked out of 5
     */
    public Skills withProficiency(Proficiency proficiency) {
        Utils.checkNotNull(proficiency, "proficiency");
        this.proficiency = JsonNullable.of(proficiency);
        return this;
    }

    /**
     * The user proficiency level of the skill ranked out of 5
     */
    public Skills withProficiency(JsonNullable<? extends Proficiency> proficiency) {
        Utils.checkNotNull(proficiency, "proficiency");
        this.proficiency = proficiency;
        return this;
    }

    /**
     * The language associated with this skill
     */
    public Skills withLanguage(SkillsLanguage language) {
        Utils.checkNotNull(language, "language");
        this.language = JsonNullable.of(language);
        return this;
    }

    /**
     * The language associated with this skill
     */
    public Skills withLanguage(JsonNullable<? extends SkillsLanguage> language) {
        Utils.checkNotNull(language, "language");
        this.language = language;
        return this;
    }

    /**
     * The hierarchal level of the skill
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Skills withLevel(SkillsLevel level) {
        Utils.checkNotNull(level, "level");
        this.level = JsonNullable.of(level);
        return this;
    }

    /**
     * The hierarchal level of the skill
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Skills withLevel(JsonNullable<? extends SkillsLevel> level) {
        Utils.checkNotNull(level, "level");
        this.level = level;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Skills other = (Skills) o;
        return 
            Objects.deepEquals(this.id, other.id) &&
            Objects.deepEquals(this.remoteId, other.remoteId) &&
            Objects.deepEquals(this.name, other.name) &&
            Objects.deepEquals(this.active, other.active) &&
            Objects.deepEquals(this.hierarchy, other.hierarchy) &&
            Objects.deepEquals(this.proficiency, other.proficiency) &&
            Objects.deepEquals(this.language, other.language) &&
            Objects.deepEquals(this.level, other.level);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            id,
            remoteId,
            name,
            active,
            hierarchy,
            proficiency,
            language,
            level);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Skills.class,
                "id", id,
                "remoteId", remoteId,
                "name", name,
                "active", active,
                "hierarchy", hierarchy,
                "proficiency", proficiency,
                "language", language,
                "level", level);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> id = JsonNullable.undefined();
 
        private JsonNullable<String> remoteId = JsonNullable.undefined();
 
        private JsonNullable<String> name = JsonNullable.undefined();
 
        private JsonNullable<Boolean> active = JsonNullable.undefined();
 
        private JsonNullable<? extends SkillsHierarchy> hierarchy = JsonNullable.undefined();
 
        private JsonNullable<? extends Proficiency> proficiency = JsonNullable.undefined();
 
        private JsonNullable<? extends SkillsLanguage> language = JsonNullable.undefined();
 
        @Deprecated
        private JsonNullable<? extends SkillsLevel> level = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The ID associated with this skill
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * The ID associated with this skill
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }

        /**
         * The name associated with this skill
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        /**
         * The name associated with this skill
         */
        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        /**
         * Whether the skill is active and therefore available for use
         */
        public Builder active(boolean active) {
            Utils.checkNotNull(active, "active");
            this.active = JsonNullable.of(active);
            return this;
        }

        /**
         * Whether the skill is active and therefore available for use
         */
        public Builder active(JsonNullable<Boolean> active) {
            Utils.checkNotNull(active, "active");
            this.active = active;
            return this;
        }

        /**
         * The hierarchal level of the skill
         */
        public Builder hierarchy(SkillsHierarchy hierarchy) {
            Utils.checkNotNull(hierarchy, "hierarchy");
            this.hierarchy = JsonNullable.of(hierarchy);
            return this;
        }

        /**
         * The hierarchal level of the skill
         */
        public Builder hierarchy(JsonNullable<? extends SkillsHierarchy> hierarchy) {
            Utils.checkNotNull(hierarchy, "hierarchy");
            this.hierarchy = hierarchy;
            return this;
        }

        /**
         * The user proficiency level of the skill ranked out of 5
         */
        public Builder proficiency(Proficiency proficiency) {
            Utils.checkNotNull(proficiency, "proficiency");
            this.proficiency = JsonNullable.of(proficiency);
            return this;
        }

        /**
         * The user proficiency level of the skill ranked out of 5
         */
        public Builder proficiency(JsonNullable<? extends Proficiency> proficiency) {
            Utils.checkNotNull(proficiency, "proficiency");
            this.proficiency = proficiency;
            return this;
        }

        /**
         * The language associated with this skill
         */
        public Builder language(SkillsLanguage language) {
            Utils.checkNotNull(language, "language");
            this.language = JsonNullable.of(language);
            return this;
        }

        /**
         * The language associated with this skill
         */
        public Builder language(JsonNullable<? extends SkillsLanguage> language) {
            Utils.checkNotNull(language, "language");
            this.language = language;
            return this;
        }

        /**
         * The hierarchal level of the skill
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder level(SkillsLevel level) {
            Utils.checkNotNull(level, "level");
            this.level = JsonNullable.of(level);
            return this;
        }

        /**
         * The hierarchal level of the skill
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder level(JsonNullable<? extends SkillsLevel> level) {
            Utils.checkNotNull(level, "level");
            this.level = level;
            return this;
        }
        
        public Skills build() {
            return new Skills(
                id,
                remoteId,
                name,
                active,
                hierarchy,
                proficiency,
                language,
                level);
        }
    }
}

