/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.IamGroup;
import com.stackone.stackone_client_java.models.components.RawResponse;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.List;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class IamGroupResult {
    @JsonProperty(value="data")
    private IamGroup data;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="raw")
    private JsonNullable<? extends List<RawResponse>> raw;

    @JsonCreator
    public IamGroupResult(@JsonProperty(value="data") IamGroup data, @JsonProperty(value="raw") JsonNullable<? extends List<RawResponse>> raw) {
        Utils.checkNotNull(data, "data");
        Utils.checkNotNull(raw, "raw");
        this.data = data;
        this.raw = raw;
    }

    public IamGroupResult(IamGroup data) {
        this(data, (JsonNullable<? extends List<RawResponse>>)JsonNullable.undefined());
    }

    @JsonIgnore
    public IamGroup data() {
        return this.data;
    }

    @JsonIgnore
    public JsonNullable<List<RawResponse>> raw() {
        return this.raw;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public IamGroupResult withData(IamGroup data) {
        Utils.checkNotNull(data, "data");
        this.data = data;
        return this;
    }

    public IamGroupResult withRaw(List<RawResponse> raw) {
        Utils.checkNotNull(raw, "raw");
        this.raw = JsonNullable.of(raw);
        return this;
    }

    public IamGroupResult withRaw(JsonNullable<? extends List<RawResponse>> raw) {
        Utils.checkNotNull(raw, "raw");
        this.raw = raw;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IamGroupResult other = (IamGroupResult)o;
        return Objects.deepEquals(this.data, other.data) && Objects.deepEquals(this.raw, other.raw);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.raw);
    }

    public String toString() {
        return Utils.toString(IamGroupResult.class, "data", this.data, "raw", this.raw);
    }

    public static final class Builder {
        private IamGroup data;
        private JsonNullable<? extends List<RawResponse>> raw = JsonNullable.undefined();

        private Builder() {
        }

        public Builder data(IamGroup data) {
            Utils.checkNotNull(data, "data");
            this.data = data;
            return this;
        }

        public Builder raw(List<RawResponse> raw) {
            Utils.checkNotNull(raw, "raw");
            this.raw = JsonNullable.of(raw);
            return this;
        }

        public Builder raw(JsonNullable<? extends List<RawResponse>> raw) {
            Utils.checkNotNull(raw, "raw");
            this.raw = raw;
            return this;
        }

        public IamGroupResult build() {
            return new IamGroupResult(this.data, this.raw);
        }
    }
}

