/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.TicketingListUsersRequest;
import com.stackone.stackone_client_java.models.operations.TicketingListUsersResponse;
import com.stackone.stackone_client_java.operations.TicketingListUsers;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class TicketingListUsersRequestBuilder {
    private TicketingListUsersRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public TicketingListUsersRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public TicketingListUsersRequestBuilder request(TicketingListUsersRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public TicketingListUsersRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public TicketingListUsersRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public TicketingListUsersResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        TicketingListUsers.Sync operation = new TicketingListUsers.Sync(this.sdkConfiguration, options);
        return (TicketingListUsersResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<TicketingListUsersResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        TicketingListUsers.Sync operation = new TicketingListUsers.Sync(this.sdkConfiguration, options);
        Paginator<TicketingListUsersRequest, String> iterator = new Paginator<TicketingListUsersRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), TicketingListUsersRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<TicketingListUsersResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

