/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ScreeningCreateOrderRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;

public class ScreeningCreateScreeningOrderRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private ScreeningCreateOrderRequestDto screeningCreateOrderRequestDto;

    @JsonCreator
    public ScreeningCreateScreeningOrderRequest(String xAccountId, ScreeningCreateOrderRequestDto screeningCreateOrderRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(screeningCreateOrderRequestDto, "screeningCreateOrderRequestDto");
        this.xAccountId = xAccountId;
        this.screeningCreateOrderRequestDto = screeningCreateOrderRequestDto;
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public ScreeningCreateOrderRequestDto screeningCreateOrderRequestDto() {
        return this.screeningCreateOrderRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ScreeningCreateScreeningOrderRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public ScreeningCreateScreeningOrderRequest withScreeningCreateOrderRequestDto(ScreeningCreateOrderRequestDto screeningCreateOrderRequestDto) {
        Utils.checkNotNull(screeningCreateOrderRequestDto, "screeningCreateOrderRequestDto");
        this.screeningCreateOrderRequestDto = screeningCreateOrderRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScreeningCreateScreeningOrderRequest other = (ScreeningCreateScreeningOrderRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.screeningCreateOrderRequestDto, other.screeningCreateOrderRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.screeningCreateOrderRequestDto);
    }

    public String toString() {
        return Utils.toString(ScreeningCreateScreeningOrderRequest.class, "xAccountId", this.xAccountId, "screeningCreateOrderRequestDto", this.screeningCreateOrderRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private ScreeningCreateOrderRequestDto screeningCreateOrderRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder screeningCreateOrderRequestDto(ScreeningCreateOrderRequestDto screeningCreateOrderRequestDto) {
            Utils.checkNotNull(screeningCreateOrderRequestDto, "screeningCreateOrderRequestDto");
            this.screeningCreateOrderRequestDto = screeningCreateOrderRequestDto;
            return this;
        }

        public ScreeningCreateScreeningOrderRequest build() {
            return new ScreeningCreateScreeningOrderRequest(this.xAccountId, this.screeningCreateOrderRequestDto);
        }
    }
}

