/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations.async;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.LmsCreateAssignmentRequestDto;
import com.stackone.stackone_client_java.models.operations.LmsCreateUserAssignmentRequest;
import com.stackone.stackone_client_java.operations.LmsCreateUserAssignment;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Exception;
import java.lang.String;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class LmsCreateUserAssignmentRequestBuilder {

    private String xAccountId;
    private String id;
    private LmsCreateAssignmentRequestDto lmsCreateAssignmentRequestDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers(); 

    public LmsCreateUserAssignmentRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public LmsCreateUserAssignmentRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public LmsCreateUserAssignmentRequestBuilder id(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public LmsCreateUserAssignmentRequestBuilder lmsCreateAssignmentRequestDto(LmsCreateAssignmentRequestDto lmsCreateAssignmentRequestDto) {
        Utils.checkNotNull(lmsCreateAssignmentRequestDto, "lmsCreateAssignmentRequestDto");
        this.lmsCreateAssignmentRequestDto = lmsCreateAssignmentRequestDto;
        return this;
    }
                
    public LmsCreateUserAssignmentRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public LmsCreateUserAssignmentRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }


    private LmsCreateUserAssignmentRequest buildRequest() {

        LmsCreateUserAssignmentRequest request = new LmsCreateUserAssignmentRequest(xAccountId,
            id,
            lmsCreateAssignmentRequestDto);

        return request;
    }

    public CompletableFuture<LmsCreateUserAssignmentResponse> call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        AsyncRequestOperation<LmsCreateUserAssignmentRequest, LmsCreateUserAssignmentResponse> operation
              = new LmsCreateUserAssignment.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        LmsCreateUserAssignmentRequest request = buildRequest();

        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }
}
