/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;

public class ActionsRpcRequestDto {
    @JsonProperty(value="action")
    private String action;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="path")
    private JsonNullable<? extends Map<String, Object>> path;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="query")
    private JsonNullable<? extends Map<String, Object>> query;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="headers")
    private JsonNullable<? extends Map<String, Object>> headers;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="body")
    private JsonNullable<? extends Map<String, Object>> body;

    @JsonCreator
    public ActionsRpcRequestDto(@JsonProperty(value="action") String action, @JsonProperty(value="path") JsonNullable<? extends Map<String, Object>> path, @JsonProperty(value="query") JsonNullable<? extends Map<String, Object>> query, @JsonProperty(value="headers") JsonNullable<? extends Map<String, Object>> headers, @JsonProperty(value="body") JsonNullable<? extends Map<String, Object>> body) {
        Utils.checkNotNull(action, "action");
        Utils.checkNotNull(path, "path");
        Utils.checkNotNull(query, "query");
        Utils.checkNotNull(headers, "headers");
        Utils.checkNotNull(body, "body");
        this.action = action;
        this.path = path;
        this.query = query;
        this.headers = headers;
        this.body = body;
    }

    public ActionsRpcRequestDto(String action) {
        this(action, (JsonNullable<? extends Map<String, Object>>)JsonNullable.undefined(), (JsonNullable<? extends Map<String, Object>>)JsonNullable.undefined(), (JsonNullable<? extends Map<String, Object>>)JsonNullable.undefined(), (JsonNullable<? extends Map<String, Object>>)JsonNullable.undefined());
    }

    @JsonIgnore
    public String action() {
        return this.action;
    }

    @JsonIgnore
    public JsonNullable<Map<String, Object>> path() {
        return this.path;
    }

    @JsonIgnore
    public JsonNullable<Map<String, Object>> query() {
        return this.query;
    }

    @JsonIgnore
    public JsonNullable<Map<String, Object>> headers() {
        return this.headers;
    }

    @JsonIgnore
    public JsonNullable<Map<String, Object>> body() {
        return this.body;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ActionsRpcRequestDto withAction(String action) {
        Utils.checkNotNull(action, "action");
        this.action = action;
        return this;
    }

    public ActionsRpcRequestDto withPath(Map<String, Object> path) {
        Utils.checkNotNull(path, "path");
        this.path = JsonNullable.of(path);
        return this;
    }

    public ActionsRpcRequestDto withPath(JsonNullable<? extends Map<String, Object>> path) {
        Utils.checkNotNull(path, "path");
        this.path = path;
        return this;
    }

    public ActionsRpcRequestDto withQuery(Map<String, Object> query) {
        Utils.checkNotNull(query, "query");
        this.query = JsonNullable.of(query);
        return this;
    }

    public ActionsRpcRequestDto withQuery(JsonNullable<? extends Map<String, Object>> query) {
        Utils.checkNotNull(query, "query");
        this.query = query;
        return this;
    }

    public ActionsRpcRequestDto withHeaders(Map<String, Object> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = JsonNullable.of(headers);
        return this;
    }

    public ActionsRpcRequestDto withHeaders(JsonNullable<? extends Map<String, Object>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public ActionsRpcRequestDto withBody(Map<String, Object> body) {
        Utils.checkNotNull(body, "body");
        this.body = JsonNullable.of(body);
        return this;
    }

    public ActionsRpcRequestDto withBody(JsonNullable<? extends Map<String, Object>> body) {
        Utils.checkNotNull(body, "body");
        this.body = body;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionsRpcRequestDto other = (ActionsRpcRequestDto)o;
        return Utils.enhancedDeepEquals(this.action, other.action) && Utils.enhancedDeepEquals(this.path, other.path) && Utils.enhancedDeepEquals(this.query, other.query) && Utils.enhancedDeepEquals(this.headers, other.headers) && Utils.enhancedDeepEquals(this.body, other.body);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.action, this.path, this.query, this.headers, this.body);
    }

    public String toString() {
        return Utils.toString(ActionsRpcRequestDto.class, "action", this.action, "path", this.path, "query", this.query, "headers", this.headers, "body", this.body);
    }

    public static final class Builder {
        private String action;
        private JsonNullable<? extends Map<String, Object>> path = JsonNullable.undefined();
        private JsonNullable<? extends Map<String, Object>> query = JsonNullable.undefined();
        private JsonNullable<? extends Map<String, Object>> headers = JsonNullable.undefined();
        private JsonNullable<? extends Map<String, Object>> body = JsonNullable.undefined();

        private Builder() {
        }

        public Builder action(String action) {
            Utils.checkNotNull(action, "action");
            this.action = action;
            return this;
        }

        public Builder path(Map<String, Object> path) {
            Utils.checkNotNull(path, "path");
            this.path = JsonNullable.of(path);
            return this;
        }

        public Builder path(JsonNullable<? extends Map<String, Object>> path) {
            Utils.checkNotNull(path, "path");
            this.path = path;
            return this;
        }

        public Builder query(Map<String, Object> query) {
            Utils.checkNotNull(query, "query");
            this.query = JsonNullable.of(query);
            return this;
        }

        public Builder query(JsonNullable<? extends Map<String, Object>> query) {
            Utils.checkNotNull(query, "query");
            this.query = query;
            return this;
        }

        public Builder headers(Map<String, Object> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = JsonNullable.of(headers);
            return this;
        }

        public Builder headers(JsonNullable<? extends Map<String, Object>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public Builder body(Map<String, Object> body) {
            Utils.checkNotNull(body, "body");
            this.body = JsonNullable.of(body);
            return this;
        }

        public Builder body(JsonNullable<? extends Map<String, Object>> body) {
            Utils.checkNotNull(body, "body");
            this.body = body;
            return this;
        }

        public ActionsRpcRequestDto build() {
            return new ActionsRpcRequestDto(this.action, this.path, this.query, this.headers, this.body);
        }
    }
}

