/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.HrisDocumentsPaginated;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisListEmployeeDocumentsResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends HrisDocumentsPaginated> hrisDocumentsPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisListEmployeeDocumentsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends HrisDocumentsPaginated> hrisDocumentsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(hrisDocumentsPaginated, "hrisDocumentsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.hrisDocumentsPaginated = hrisDocumentsPaginated;
        this.headers = headers;
    }

    public HrisListEmployeeDocumentsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<HrisDocumentsPaginated> hrisDocumentsPaginated() {
        return this.hrisDocumentsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisListEmployeeDocumentsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisListEmployeeDocumentsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisListEmployeeDocumentsResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisListEmployeeDocumentsResponse withHrisDocumentsPaginated(HrisDocumentsPaginated hrisDocumentsPaginated) {
        Utils.checkNotNull(hrisDocumentsPaginated, "hrisDocumentsPaginated");
        this.hrisDocumentsPaginated = Optional.ofNullable(hrisDocumentsPaginated);
        return this;
    }

    public HrisListEmployeeDocumentsResponse withHrisDocumentsPaginated(Optional<? extends HrisDocumentsPaginated> hrisDocumentsPaginated) {
        Utils.checkNotNull(hrisDocumentsPaginated, "hrisDocumentsPaginated");
        this.hrisDocumentsPaginated = hrisDocumentsPaginated;
        return this;
    }

    public HrisListEmployeeDocumentsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisListEmployeeDocumentsResponse other = (HrisListEmployeeDocumentsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.hrisDocumentsPaginated, other.hrisDocumentsPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.hrisDocumentsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisListEmployeeDocumentsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "hrisDocumentsPaginated", this.hrisDocumentsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends HrisDocumentsPaginated> hrisDocumentsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder hrisDocumentsPaginated(HrisDocumentsPaginated hrisDocumentsPaginated) {
            Utils.checkNotNull(hrisDocumentsPaginated, "hrisDocumentsPaginated");
            this.hrisDocumentsPaginated = Optional.ofNullable(hrisDocumentsPaginated);
            return this;
        }

        public Builder hrisDocumentsPaginated(Optional<? extends HrisDocumentsPaginated> hrisDocumentsPaginated) {
            Utils.checkNotNull(hrisDocumentsPaginated, "hrisDocumentsPaginated");
            this.hrisDocumentsPaginated = hrisDocumentsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisListEmployeeDocumentsResponse build() {
            return new HrisListEmployeeDocumentsResponse(this.contentType, this.statusCode, this.rawResponse, this.hrisDocumentsPaginated, this.headers);
        }
    }
}

