/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * HrisListEmployeeShiftsQueryParamFilter
 * 
 * <p>HRIS Shifts filters
 */
public class HrisListEmployeeShiftsQueryParamFilter {
    /**
     * Use a string with a date to only select results updated after that given date
     */
    @SpeakeasyMetadata("queryParam:name=updated_after")
    private JsonNullable<OffsetDateTime> updatedAfter;

    /**
     * Filter to select shifts by status
     */
    @SpeakeasyMetadata("queryParam:name=status")
    private JsonNullable<? extends Status> status;

    /**
     * Filter shifts that start after this date
     */
    @SpeakeasyMetadata("queryParam:name=starts_after")
    private Optional<String> startsAfter;

    /**
     * Filter shifts that end before this date
     */
    @SpeakeasyMetadata("queryParam:name=ends_before")
    private Optional<String> endsBefore;

    @JsonCreator
    public HrisListEmployeeShiftsQueryParamFilter(
            JsonNullable<OffsetDateTime> updatedAfter,
            JsonNullable<? extends Status> status,
            Optional<String> startsAfter,
            Optional<String> endsBefore) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(startsAfter, "startsAfter");
        Utils.checkNotNull(endsBefore, "endsBefore");
        this.updatedAfter = updatedAfter;
        this.status = status;
        this.startsAfter = startsAfter;
        this.endsBefore = endsBefore;
    }
    
    public HrisListEmployeeShiftsQueryParamFilter() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), Optional.empty(),
            Optional.empty());
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAfter() {
        return updatedAfter;
    }

    /**
     * Filter to select shifts by status
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Status> status() {
        return (JsonNullable<Status>) status;
    }

    /**
     * Filter shifts that start after this date
     */
    @JsonIgnore
    public Optional<String> startsAfter() {
        return startsAfter;
    }

    /**
     * Filter shifts that end before this date
     */
    @JsonIgnore
    public Optional<String> endsBefore() {
        return endsBefore;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Use a string with a date to only select results updated after that given date
     */
    public HrisListEmployeeShiftsQueryParamFilter withUpdatedAfter(OffsetDateTime updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = JsonNullable.of(updatedAfter);
        return this;
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    public HrisListEmployeeShiftsQueryParamFilter withUpdatedAfter(JsonNullable<OffsetDateTime> updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = updatedAfter;
        return this;
    }

    /**
     * Filter to select shifts by status
     */
    public HrisListEmployeeShiftsQueryParamFilter withStatus(Status status) {
        Utils.checkNotNull(status, "status");
        this.status = JsonNullable.of(status);
        return this;
    }

    /**
     * Filter to select shifts by status
     */
    public HrisListEmployeeShiftsQueryParamFilter withStatus(JsonNullable<? extends Status> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    /**
     * Filter shifts that start after this date
     */
    public HrisListEmployeeShiftsQueryParamFilter withStartsAfter(String startsAfter) {
        Utils.checkNotNull(startsAfter, "startsAfter");
        this.startsAfter = Optional.ofNullable(startsAfter);
        return this;
    }


    /**
     * Filter shifts that start after this date
     */
    public HrisListEmployeeShiftsQueryParamFilter withStartsAfter(Optional<String> startsAfter) {
        Utils.checkNotNull(startsAfter, "startsAfter");
        this.startsAfter = startsAfter;
        return this;
    }

    /**
     * Filter shifts that end before this date
     */
    public HrisListEmployeeShiftsQueryParamFilter withEndsBefore(String endsBefore) {
        Utils.checkNotNull(endsBefore, "endsBefore");
        this.endsBefore = Optional.ofNullable(endsBefore);
        return this;
    }


    /**
     * Filter shifts that end before this date
     */
    public HrisListEmployeeShiftsQueryParamFilter withEndsBefore(Optional<String> endsBefore) {
        Utils.checkNotNull(endsBefore, "endsBefore");
        this.endsBefore = endsBefore;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HrisListEmployeeShiftsQueryParamFilter other = (HrisListEmployeeShiftsQueryParamFilter) o;
        return 
            Utils.enhancedDeepEquals(this.updatedAfter, other.updatedAfter) &&
            Utils.enhancedDeepEquals(this.status, other.status) &&
            Utils.enhancedDeepEquals(this.startsAfter, other.startsAfter) &&
            Utils.enhancedDeepEquals(this.endsBefore, other.endsBefore);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            updatedAfter, status, startsAfter,
            endsBefore);
    }
    
    @Override
    public String toString() {
        return Utils.toString(HrisListEmployeeShiftsQueryParamFilter.class,
                "updatedAfter", updatedAfter,
                "status", status,
                "startsAfter", startsAfter,
                "endsBefore", endsBefore);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<OffsetDateTime> updatedAfter = JsonNullable.undefined();

        private JsonNullable<? extends Status> status = JsonNullable.undefined();

        private Optional<String> startsAfter = Optional.empty();

        private Optional<String> endsBefore = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(OffsetDateTime updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = JsonNullable.of(updatedAfter);
            return this;
        }

        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(JsonNullable<OffsetDateTime> updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = updatedAfter;
            return this;
        }


        /**
         * Filter to select shifts by status
         */
        public Builder status(Status status) {
            Utils.checkNotNull(status, "status");
            this.status = JsonNullable.of(status);
            return this;
        }

        /**
         * Filter to select shifts by status
         */
        public Builder status(JsonNullable<? extends Status> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }


        /**
         * Filter shifts that start after this date
         */
        public Builder startsAfter(String startsAfter) {
            Utils.checkNotNull(startsAfter, "startsAfter");
            this.startsAfter = Optional.ofNullable(startsAfter);
            return this;
        }

        /**
         * Filter shifts that start after this date
         */
        public Builder startsAfter(Optional<String> startsAfter) {
            Utils.checkNotNull(startsAfter, "startsAfter");
            this.startsAfter = startsAfter;
            return this;
        }


        /**
         * Filter shifts that end before this date
         */
        public Builder endsBefore(String endsBefore) {
            Utils.checkNotNull(endsBefore, "endsBefore");
            this.endsBefore = Optional.ofNullable(endsBefore);
            return this;
        }

        /**
         * Filter shifts that end before this date
         */
        public Builder endsBefore(Optional<String> endsBefore) {
            Utils.checkNotNull(endsBefore, "endsBefore");
            this.endsBefore = endsBefore;
            return this;
        }

        public HrisListEmployeeShiftsQueryParamFilter build() {

            return new HrisListEmployeeShiftsQueryParamFilter(
                updatedAfter, status, startsAfter,
                endsBefore);
        }

    }
}
