/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Double;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;


public class StackoneListPlatformLogsRequest {
    /**
     * The field to order the results by.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=order_by")
    private JsonNullable<? extends StackoneListPlatformLogsQueryParamOrderBy> orderBy;

    /**
     * The direction to order the results by.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=order_direction")
    private JsonNullable<? extends StackoneListPlatformLogsQueryParamOrderDirection> orderDirection;

    /**
     * The number of results per page (default value is 25)
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=page_size")
    private JsonNullable<Double> pageSize;

    /**
     * The unified cursor
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=next")
    private JsonNullable<String> next;

    /**
     * Filter parameters that allow greater customisation of the list response
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=filter")
    private JsonNullable<? extends StackoneListPlatformLogsQueryParamFilter> filter;

    @JsonCreator
    public StackoneListPlatformLogsRequest(
            JsonNullable<? extends StackoneListPlatformLogsQueryParamOrderBy> orderBy,
            JsonNullable<? extends StackoneListPlatformLogsQueryParamOrderDirection> orderDirection,
            JsonNullable<Double> pageSize,
            JsonNullable<String> next,
            JsonNullable<? extends StackoneListPlatformLogsQueryParamFilter> filter) {
        Utils.checkNotNull(orderBy, "orderBy");
        Utils.checkNotNull(orderDirection, "orderDirection");
        Utils.checkNotNull(pageSize, "pageSize");
        Utils.checkNotNull(next, "next");
        Utils.checkNotNull(filter, "filter");
        this.orderBy = orderBy;
        this.orderDirection = orderDirection;
        this.pageSize = pageSize;
        this.next = next;
        this.filter = filter;
    }
    
    public StackoneListPlatformLogsRequest() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The field to order the results by.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<StackoneListPlatformLogsQueryParamOrderBy> orderBy() {
        return (JsonNullable<StackoneListPlatformLogsQueryParamOrderBy>) orderBy;
    }

    /**
     * The direction to order the results by.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<StackoneListPlatformLogsQueryParamOrderDirection> orderDirection() {
        return (JsonNullable<StackoneListPlatformLogsQueryParamOrderDirection>) orderDirection;
    }

    /**
     * The number of results per page (default value is 25)
     */
    @JsonIgnore
    public JsonNullable<Double> pageSize() {
        return pageSize;
    }

    /**
     * The unified cursor
     */
    @JsonIgnore
    public JsonNullable<String> next() {
        return next;
    }

    /**
     * Filter parameters that allow greater customisation of the list response
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<StackoneListPlatformLogsQueryParamFilter> filter() {
        return (JsonNullable<StackoneListPlatformLogsQueryParamFilter>) filter;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The field to order the results by.
     */
    public StackoneListPlatformLogsRequest withOrderBy(StackoneListPlatformLogsQueryParamOrderBy orderBy) {
        Utils.checkNotNull(orderBy, "orderBy");
        this.orderBy = JsonNullable.of(orderBy);
        return this;
    }

    /**
     * The field to order the results by.
     */
    public StackoneListPlatformLogsRequest withOrderBy(JsonNullable<? extends StackoneListPlatformLogsQueryParamOrderBy> orderBy) {
        Utils.checkNotNull(orderBy, "orderBy");
        this.orderBy = orderBy;
        return this;
    }

    /**
     * The direction to order the results by.
     */
    public StackoneListPlatformLogsRequest withOrderDirection(StackoneListPlatformLogsQueryParamOrderDirection orderDirection) {
        Utils.checkNotNull(orderDirection, "orderDirection");
        this.orderDirection = JsonNullable.of(orderDirection);
        return this;
    }

    /**
     * The direction to order the results by.
     */
    public StackoneListPlatformLogsRequest withOrderDirection(JsonNullable<? extends StackoneListPlatformLogsQueryParamOrderDirection> orderDirection) {
        Utils.checkNotNull(orderDirection, "orderDirection");
        this.orderDirection = orderDirection;
        return this;
    }

    /**
     * The number of results per page (default value is 25)
     */
    public StackoneListPlatformLogsRequest withPageSize(double pageSize) {
        Utils.checkNotNull(pageSize, "pageSize");
        this.pageSize = JsonNullable.of(pageSize);
        return this;
    }

    /**
     * The number of results per page (default value is 25)
     */
    public StackoneListPlatformLogsRequest withPageSize(JsonNullable<Double> pageSize) {
        Utils.checkNotNull(pageSize, "pageSize");
        this.pageSize = pageSize;
        return this;
    }

    /**
     * The unified cursor
     */
    public StackoneListPlatformLogsRequest withNext(String next) {
        Utils.checkNotNull(next, "next");
        this.next = JsonNullable.of(next);
        return this;
    }

    /**
     * The unified cursor
     */
    public StackoneListPlatformLogsRequest withNext(JsonNullable<String> next) {
        Utils.checkNotNull(next, "next");
        this.next = next;
        return this;
    }

    /**
     * Filter parameters that allow greater customisation of the list response
     */
    public StackoneListPlatformLogsRequest withFilter(StackoneListPlatformLogsQueryParamFilter filter) {
        Utils.checkNotNull(filter, "filter");
        this.filter = JsonNullable.of(filter);
        return this;
    }

    /**
     * Filter parameters that allow greater customisation of the list response
     */
    public StackoneListPlatformLogsRequest withFilter(JsonNullable<? extends StackoneListPlatformLogsQueryParamFilter> filter) {
        Utils.checkNotNull(filter, "filter");
        this.filter = filter;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StackoneListPlatformLogsRequest other = (StackoneListPlatformLogsRequest) o;
        return 
            Utils.enhancedDeepEquals(this.orderBy, other.orderBy) &&
            Utils.enhancedDeepEquals(this.orderDirection, other.orderDirection) &&
            Utils.enhancedDeepEquals(this.pageSize, other.pageSize) &&
            Utils.enhancedDeepEquals(this.next, other.next) &&
            Utils.enhancedDeepEquals(this.filter, other.filter);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            orderBy, orderDirection, pageSize,
            next, filter);
    }
    
    @Override
    public String toString() {
        return Utils.toString(StackoneListPlatformLogsRequest.class,
                "orderBy", orderBy,
                "orderDirection", orderDirection,
                "pageSize", pageSize,
                "next", next,
                "filter", filter);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<? extends StackoneListPlatformLogsQueryParamOrderBy> orderBy = JsonNullable.undefined();

        private JsonNullable<? extends StackoneListPlatformLogsQueryParamOrderDirection> orderDirection = JsonNullable.undefined();

        private JsonNullable<Double> pageSize = JsonNullable.undefined();

        private JsonNullable<String> next = JsonNullable.undefined();

        private JsonNullable<? extends StackoneListPlatformLogsQueryParamFilter> filter = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The field to order the results by.
         */
        public Builder orderBy(StackoneListPlatformLogsQueryParamOrderBy orderBy) {
            Utils.checkNotNull(orderBy, "orderBy");
            this.orderBy = JsonNullable.of(orderBy);
            return this;
        }

        /**
         * The field to order the results by.
         */
        public Builder orderBy(JsonNullable<? extends StackoneListPlatformLogsQueryParamOrderBy> orderBy) {
            Utils.checkNotNull(orderBy, "orderBy");
            this.orderBy = orderBy;
            return this;
        }


        /**
         * The direction to order the results by.
         */
        public Builder orderDirection(StackoneListPlatformLogsQueryParamOrderDirection orderDirection) {
            Utils.checkNotNull(orderDirection, "orderDirection");
            this.orderDirection = JsonNullable.of(orderDirection);
            return this;
        }

        /**
         * The direction to order the results by.
         */
        public Builder orderDirection(JsonNullable<? extends StackoneListPlatformLogsQueryParamOrderDirection> orderDirection) {
            Utils.checkNotNull(orderDirection, "orderDirection");
            this.orderDirection = orderDirection;
            return this;
        }


        /**
         * The number of results per page (default value is 25)
         */
        public Builder pageSize(double pageSize) {
            Utils.checkNotNull(pageSize, "pageSize");
            this.pageSize = JsonNullable.of(pageSize);
            return this;
        }

        /**
         * The number of results per page (default value is 25)
         */
        public Builder pageSize(JsonNullable<Double> pageSize) {
            Utils.checkNotNull(pageSize, "pageSize");
            this.pageSize = pageSize;
            return this;
        }


        /**
         * The unified cursor
         */
        public Builder next(String next) {
            Utils.checkNotNull(next, "next");
            this.next = JsonNullable.of(next);
            return this;
        }

        /**
         * The unified cursor
         */
        public Builder next(JsonNullable<String> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }


        /**
         * Filter parameters that allow greater customisation of the list response
         */
        public Builder filter(StackoneListPlatformLogsQueryParamFilter filter) {
            Utils.checkNotNull(filter, "filter");
            this.filter = JsonNullable.of(filter);
            return this;
        }

        /**
         * Filter parameters that allow greater customisation of the list response
         */
        public Builder filter(JsonNullable<? extends StackoneListPlatformLogsQueryParamFilter> filter) {
            Utils.checkNotNull(filter, "filter");
            this.filter = filter;
            return this;
        }

        public StackoneListPlatformLogsRequest build() {

            return new StackoneListPlatformLogsRequest(
                orderBy, orderDirection, pageSize,
                next, filter);
        }

    }
}
