/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.SchemeBasic;
import com.stackone.stackone_client_java.utils.HasSecurity;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


public class StackoneMcpGetSecurity implements HasSecurity {

    @SpeakeasyMetadata("security:scheme=true,type=http,subtype=basic")
    private Optional<? extends SchemeBasic> basic;


    @SpeakeasyMetadata("security:scheme=true,type=apiKey,subtype=header,name=Authorization")
    private Optional<String> apiKey;

    @JsonCreator
    public StackoneMcpGetSecurity(
            Optional<? extends SchemeBasic> basic,
            Optional<String> apiKey) {
        Utils.checkNotNull(basic, "basic");
        Utils.checkNotNull(apiKey, "apiKey");
        this.basic = basic;
        this.apiKey = apiKey;
    }
    
    public StackoneMcpGetSecurity() {
        this(Optional.empty(), Optional.empty());
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<SchemeBasic> basic() {
        return (Optional<SchemeBasic>) basic;
    }

    @JsonIgnore
    public Optional<String> apiKey() {
        return apiKey;
    }

    public static Builder builder() {
        return new Builder();
    }


    public StackoneMcpGetSecurity withBasic(SchemeBasic basic) {
        Utils.checkNotNull(basic, "basic");
        this.basic = Optional.ofNullable(basic);
        return this;
    }


    public StackoneMcpGetSecurity withBasic(Optional<? extends SchemeBasic> basic) {
        Utils.checkNotNull(basic, "basic");
        this.basic = basic;
        return this;
    }

    public StackoneMcpGetSecurity withApiKey(String apiKey) {
        Utils.checkNotNull(apiKey, "apiKey");
        this.apiKey = Optional.ofNullable(apiKey);
        return this;
    }


    public StackoneMcpGetSecurity withApiKey(Optional<String> apiKey) {
        Utils.checkNotNull(apiKey, "apiKey");
        this.apiKey = apiKey;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StackoneMcpGetSecurity other = (StackoneMcpGetSecurity) o;
        return 
            Utils.enhancedDeepEquals(this.basic, other.basic) &&
            Utils.enhancedDeepEquals(this.apiKey, other.apiKey);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            basic, apiKey);
    }
    
    @Override
    public String toString() {
        return Utils.toString(StackoneMcpGetSecurity.class,
                "basic", basic,
                "apiKey", apiKey);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<? extends SchemeBasic> basic = Optional.empty();

        private Optional<String> apiKey = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder basic(SchemeBasic basic) {
            Utils.checkNotNull(basic, "basic");
            this.basic = Optional.ofNullable(basic);
            return this;
        }

        public Builder basic(Optional<? extends SchemeBasic> basic) {
            Utils.checkNotNull(basic, "basic");
            this.basic = basic;
            return this;
        }


        public Builder apiKey(String apiKey) {
            Utils.checkNotNull(apiKey, "apiKey");
            this.apiKey = Optional.ofNullable(apiKey);
            return this;
        }

        public Builder apiKey(Optional<String> apiKey) {
            Utils.checkNotNull(apiKey, "apiKey");
            this.apiKey = apiKey;
            return this;
        }

        public StackoneMcpGetSecurity build() {

            return new StackoneMcpGetSecurity(
                basic, apiKey);
        }

    }
}
