/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations.async;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.AtsCreateJobRequestDto;
import com.stackone.stackone_client_java.models.operations.AtsCreateJobRequest;
import com.stackone.stackone_client_java.operations.AtsCreateJob;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Exception;
import java.lang.String;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AtsCreateJobRequestBuilder {

    private String xAccountId;
    private AtsCreateJobRequestDto atsCreateJobRequestDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers(); 

    public AtsCreateJobRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public AtsCreateJobRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsCreateJobRequestBuilder atsCreateJobRequestDto(AtsCreateJobRequestDto atsCreateJobRequestDto) {
        Utils.checkNotNull(atsCreateJobRequestDto, "atsCreateJobRequestDto");
        this.atsCreateJobRequestDto = atsCreateJobRequestDto;
        return this;
    }
                
    public AtsCreateJobRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public AtsCreateJobRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }


    private AtsCreateJobRequest buildRequest() {

        AtsCreateJobRequest request = new AtsCreateJobRequest(xAccountId,
            atsCreateJobRequestDto);

        return request;
    }

    public CompletableFuture<AtsCreateJobResponse> call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        AsyncRequestOperation<AtsCreateJobRequest, AtsCreateJobResponse> operation
              = new AtsCreateJob.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        AtsCreateJobRequest request = buildRequest();

        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }
}
