/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.HRISDivisionsResult;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisGetDivisionGroupResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends HRISDivisionsResult> hrisDivisionsResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisGetDivisionGroupResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends HRISDivisionsResult> hrisDivisionsResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(hrisDivisionsResult, "hrisDivisionsResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.hrisDivisionsResult = hrisDivisionsResult;
        this.headers = headers;
    }

    public HrisGetDivisionGroupResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<HRISDivisionsResult> hrisDivisionsResult() {
        return this.hrisDivisionsResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisGetDivisionGroupResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisGetDivisionGroupResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisGetDivisionGroupResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisGetDivisionGroupResponse withHRISDivisionsResult(HRISDivisionsResult hrisDivisionsResult) {
        Utils.checkNotNull(hrisDivisionsResult, "hrisDivisionsResult");
        this.hrisDivisionsResult = Optional.ofNullable(hrisDivisionsResult);
        return this;
    }

    public HrisGetDivisionGroupResponse withHRISDivisionsResult(Optional<? extends HRISDivisionsResult> hrisDivisionsResult) {
        Utils.checkNotNull(hrisDivisionsResult, "hrisDivisionsResult");
        this.hrisDivisionsResult = hrisDivisionsResult;
        return this;
    }

    public HrisGetDivisionGroupResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisGetDivisionGroupResponse other = (HrisGetDivisionGroupResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.hrisDivisionsResult, other.hrisDivisionsResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.hrisDivisionsResult, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisGetDivisionGroupResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "hrisDivisionsResult", this.hrisDivisionsResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends HRISDivisionsResult> hrisDivisionsResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder hrisDivisionsResult(HRISDivisionsResult hrisDivisionsResult) {
            Utils.checkNotNull(hrisDivisionsResult, "hrisDivisionsResult");
            this.hrisDivisionsResult = Optional.ofNullable(hrisDivisionsResult);
            return this;
        }

        public Builder hrisDivisionsResult(Optional<? extends HRISDivisionsResult> hrisDivisionsResult) {
            Utils.checkNotNull(hrisDivisionsResult, "hrisDivisionsResult");
            this.hrisDivisionsResult = hrisDivisionsResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisGetDivisionGroupResponse build() {
            return new HrisGetDivisionGroupResponse(this.contentType, this.statusCode, this.rawResponse, this.hrisDivisionsResult, this.headers);
        }
    }
}

