/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java;

import static com.stackone.stackone_client_java.operations.Operations.RequestOperation;

import com.stackone.stackone_client_java.models.operations.Include;
import com.stackone.stackone_client_java.models.operations.StackoneGetLogRequest;
import com.stackone.stackone_client_java.models.operations.StackoneGetLogRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneGetLogResponse;
import com.stackone.stackone_client_java.models.operations.StackoneListLogsRequest;
import com.stackone.stackone_client_java.models.operations.StackoneListLogsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneListLogsResponse;
import com.stackone.stackone_client_java.models.operations.StackoneListPlatformLogsRequest;
import com.stackone.stackone_client_java.models.operations.StackoneListPlatformLogsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneListPlatformLogsResponse;
import com.stackone.stackone_client_java.models.operations.StackoneListStepLogsRequest;
import com.stackone.stackone_client_java.models.operations.StackoneListStepLogsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneListStepLogsResponse;
import com.stackone.stackone_client_java.operations.StackoneGetLog;
import com.stackone.stackone_client_java.operations.StackoneListLogs;
import com.stackone.stackone_client_java.operations.StackoneListPlatformLogs;
import com.stackone.stackone_client_java.operations.StackoneListStepLogs;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import java.lang.String;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * API requests and response logs.
 */
public class RequestLogs {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final AsyncRequestLogs asyncSDK;

    RequestLogs(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.asyncSDK = new AsyncRequestLogs(this, sdkConfiguration);
    }

    /**
     * Switches to the async SDK.
     * 
     * @return The async SDK
     */
    public AsyncRequestLogs async() {
        return asyncSDK;
    }

    /**
     * List Step Logs
     * 
     * @return The call builder
     */
    public StackoneListStepLogsRequestBuilder listStepLogs() {
        return new StackoneListStepLogsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Step Logs
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public StackoneListStepLogsResponse listStepLogs(StackoneListStepLogsRequest request) {
        return listStepLogs(request, Optional.empty());
    }

    /**
     * List Step Logs
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public StackoneListStepLogsResponse listStepLogs(StackoneListStepLogsRequest request, Optional<Options> options) {
        RequestOperation<StackoneListStepLogsRequest, StackoneListStepLogsResponse> operation
              = new StackoneListStepLogs.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get Log
     * 
     * @return The call builder
     */
    public StackoneGetLogRequestBuilder getLog() {
        return new StackoneGetLogRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Log
     * 
     * @param id 
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public StackoneGetLogResponse getLog(String id) {
        return getLog(id, JsonNullable.undefined(), Optional.empty());
    }

    /**
     * Get Log
     * 
     * @param id 
     * @param include The include parameter allows you to include additional data in the response.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public StackoneGetLogResponse getLog(
            String id, JsonNullable<? extends Include> include,
            Optional<Options> options) {
        StackoneGetLogRequest request =
            StackoneGetLogRequest
                .builder()
                .id(id)
                .include(include)
                .build();
        RequestOperation<StackoneGetLogRequest, StackoneGetLogResponse> operation
              = new StackoneGetLog.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List Logs
     * 
     * @return The call builder
     */
    public StackoneListLogsRequestBuilder listLogs() {
        return new StackoneListLogsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Logs
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public StackoneListLogsResponse listLogs(StackoneListLogsRequest request) {
        return listLogs(request, Optional.empty());
    }

    /**
     * List Logs
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public StackoneListLogsResponse listLogs(StackoneListLogsRequest request, Optional<Options> options) {
        RequestOperation<StackoneListLogsRequest, StackoneListLogsResponse> operation
              = new StackoneListLogs.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List Platform Logs
     * 
     * @return The call builder
     */
    public StackoneListPlatformLogsRequestBuilder listPlatformLogs() {
        return new StackoneListPlatformLogsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Platform Logs
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public StackoneListPlatformLogsResponse listPlatformLogs(StackoneListPlatformLogsRequest request) {
        return listPlatformLogs(request, Optional.empty());
    }

    /**
     * List Platform Logs
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public StackoneListPlatformLogsResponse listPlatformLogs(StackoneListPlatformLogsRequest request, Optional<Options> options) {
        RequestOperation<StackoneListPlatformLogsRequest, StackoneListPlatformLogsResponse> operation
              = new StackoneListPlatformLogs.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

}
