/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations.async;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.ConnectSessionCreate;
import com.stackone.stackone_client_java.operations.StackoneCreateConnectSession;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class StackoneCreateConnectSessionRequestBuilder {

    private ConnectSessionCreate request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers(); 

    public StackoneCreateConnectSessionRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public StackoneCreateConnectSessionRequestBuilder request(ConnectSessionCreate request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }
                
    public StackoneCreateConnectSessionRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public StackoneCreateConnectSessionRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public CompletableFuture<StackoneCreateConnectSessionResponse> call() {
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        AsyncRequestOperation<ConnectSessionCreate, StackoneCreateConnectSessionResponse> operation
              = new StackoneCreateConnectSession.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);

        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }
}
