/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.ContentBlockSourceValue;
import com.stackone.stackone_client_java.models.components.ContentBlockValue;
import com.stackone.stackone_client_java.utils.Utils;
import org.openapitools.jackson.nullable.JsonNullable;

public class ContentBlockType {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="value")
    private JsonNullable<? extends ContentBlockValue> value;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="source_value")
    private JsonNullable<? extends ContentBlockSourceValue> sourceValue;

    @JsonCreator
    public ContentBlockType(@JsonProperty(value="value") JsonNullable<? extends ContentBlockValue> value, @JsonProperty(value="source_value") JsonNullable<? extends ContentBlockSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }

    public ContentBlockType() {
        this((JsonNullable<? extends ContentBlockValue>)JsonNullable.undefined(), (JsonNullable<? extends ContentBlockSourceValue>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<ContentBlockValue> value() {
        return this.value;
    }

    @JsonIgnore
    public JsonNullable<ContentBlockSourceValue> sourceValue() {
        return this.sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ContentBlockType withValue(ContentBlockValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of((Object)value);
        return this;
    }

    public ContentBlockType withValue(JsonNullable<? extends ContentBlockValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public ContentBlockType withSourceValue(ContentBlockSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of((Object)sourceValue);
        return this;
    }

    public ContentBlockType withSourceValue(JsonNullable<? extends ContentBlockSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentBlockType other = (ContentBlockType)o;
        return Utils.enhancedDeepEquals(this.value, other.value) && Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.value, this.sourceValue);
    }

    public String toString() {
        return Utils.toString(ContentBlockType.class, "value", this.value, "sourceValue", this.sourceValue);
    }

    public static final class Builder {
        private JsonNullable<? extends ContentBlockValue> value = JsonNullable.undefined();
        private JsonNullable<? extends ContentBlockSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
        }

        public Builder value(ContentBlockValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of((Object)value);
            return this;
        }

        public Builder value(JsonNullable<? extends ContentBlockValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(ContentBlockSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of((Object)sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends ContentBlockSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public ContentBlockType build() {
            return new ContentBlockType(this.value, this.sourceValue);
        }
    }
}

