/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.DocumentsListFoldersRequest;
import com.stackone.stackone_client_java.models.operations.DocumentsListFoldersResponse;
import com.stackone.stackone_client_java.operations.DocumentsListFolders;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class DocumentsListFoldersRequestBuilder {
    private DocumentsListFoldersRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public DocumentsListFoldersRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public DocumentsListFoldersRequestBuilder request(DocumentsListFoldersRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public DocumentsListFoldersRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public DocumentsListFoldersRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public DocumentsListFoldersResponse call() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        DocumentsListFolders.Sync operation = new DocumentsListFolders.Sync(this.sdkConfiguration, options, this._headers);
        return (DocumentsListFoldersResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<DocumentsListFoldersResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        DocumentsListFolders.Sync operation = new DocumentsListFolders.Sync(this.sdkConfiguration, options, this._headers);
        Paginator<DocumentsListFoldersRequest, String> iterator = new Paginator<DocumentsListFoldersRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), DocumentsListFoldersRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<DocumentsListFoldersResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

