/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * TaskType
 * 
 * <p>The type of the task
 */
public class TaskType {
    /**
     * The unified value for the type of the task. If the provider does not specify this type, the value
     * will be set to UnmappedValue
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends TaskValue> value;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends TaskSourceValue> sourceValue;

    @JsonCreator
    public TaskType(
            @JsonProperty("value") JsonNullable<? extends TaskValue> value,
            @JsonProperty("source_value") JsonNullable<? extends TaskSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public TaskType() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The unified value for the type of the task. If the provider does not specify this type, the value
     * will be set to UnmappedValue
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<TaskValue> value() {
        return (JsonNullable<TaskValue>) value;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<TaskSourceValue> sourceValue() {
        return (JsonNullable<TaskSourceValue>) sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The unified value for the type of the task. If the provider does not specify this type, the value
     * will be set to UnmappedValue
     */
    public TaskType withValue(TaskValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The unified value for the type of the task. If the provider does not specify this type, the value
     * will be set to UnmappedValue
     */
    public TaskType withValue(JsonNullable<? extends TaskValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public TaskType withSourceValue(TaskSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    public TaskType withSourceValue(JsonNullable<? extends TaskSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TaskType other = (TaskType) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value, sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(TaskType.class,
                "value", value,
                "sourceValue", sourceValue);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<? extends TaskValue> value = JsonNullable.undefined();

        private JsonNullable<? extends TaskSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The unified value for the type of the task. If the provider does not specify this type, the value
         * will be set to UnmappedValue
         */
        public Builder value(TaskValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The unified value for the type of the task. If the provider does not specify this type, the value
         * will be set to UnmappedValue
         */
        public Builder value(JsonNullable<? extends TaskValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }


        public Builder sourceValue(TaskSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends TaskSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public TaskType build() {

            return new TaskType(
                value, sourceValue);
        }

    }
}
