/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.utils;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Optional;

/**
 * Generic unknown wrapper for handling polymorphic types that don't have specific implementations.
 * Preserves the raw JSON data and extracts the discriminator value.
 */
public class UnknownType {
    @JsonValue
    private final JsonNode raw;

    @JsonCreator
    public UnknownType(JsonNode rawNode) {
        this.raw = rawNode;
    }

    /**
     * Extract the discriminator value from the JSON node.
     * 
     * @param key the discriminator property name
     * @return the discriminator value if present
     */
    protected Optional<String> extractDiscriminator(String key) {
        return Optional.ofNullable(raw)
                .filter(n -> n.has(key))
                .filter(n -> n.get(key).isTextual())
                .map(n -> n.get(key).asText());
    }

    /**
     * Get the raw JSON data for this unknown type.
     * 
     * @return the raw JSON node
     */
    public JsonNode asJson() {
        return raw;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UnknownType other = (UnknownType) o;
        return Utils.enhancedDeepEquals(this.raw, other.raw);
    }

    @Override
    public int hashCode() {
        return Utils.enhancedHash(raw);
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + " " + raw;
    }
}