/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.AccountingAccountSourceValue;
import com.stackone.stackone_client_java.models.components.AccountingAccountValue;
import com.stackone.stackone_client_java.utils.Utils;
import org.openapitools.jackson.nullable.JsonNullable;

public class AccountingAccountType {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="value")
    private JsonNullable<? extends AccountingAccountValue> value;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="source_value")
    private JsonNullable<? extends AccountingAccountSourceValue> sourceValue;

    @JsonCreator
    public AccountingAccountType(@JsonProperty(value="value") JsonNullable<? extends AccountingAccountValue> value, @JsonProperty(value="source_value") JsonNullable<? extends AccountingAccountSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }

    public AccountingAccountType() {
        this((JsonNullable<? extends AccountingAccountValue>)JsonNullable.undefined(), (JsonNullable<? extends AccountingAccountSourceValue>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<AccountingAccountValue> value() {
        return this.value;
    }

    @JsonIgnore
    public JsonNullable<AccountingAccountSourceValue> sourceValue() {
        return this.sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AccountingAccountType withValue(AccountingAccountValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of((Object)value);
        return this;
    }

    public AccountingAccountType withValue(JsonNullable<? extends AccountingAccountValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public AccountingAccountType withSourceValue(AccountingAccountSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of((Object)sourceValue);
        return this;
    }

    public AccountingAccountType withSourceValue(JsonNullable<? extends AccountingAccountSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountingAccountType other = (AccountingAccountType)o;
        return Utils.enhancedDeepEquals(this.value, other.value) && Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.value, this.sourceValue);
    }

    public String toString() {
        return Utils.toString(AccountingAccountType.class, "value", this.value, "sourceValue", this.sourceValue);
    }

    public static final class Builder {
        private JsonNullable<? extends AccountingAccountValue> value = JsonNullable.undefined();
        private JsonNullable<? extends AccountingAccountSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
        }

        public Builder value(AccountingAccountValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of((Object)value);
            return this;
        }

        public Builder value(JsonNullable<? extends AccountingAccountValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(AccountingAccountSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of((Object)sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends AccountingAccountSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public AccountingAccountType build() {
            return new AccountingAccountType(this.value, this.sourceValue);
        }
    }
}

