/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class JobPostingValue {
    public static final JobPostingValue LIVE = new JobPostingValue("live");
    public static final JobPostingValue DRAFT = new JobPostingValue("draft");
    public static final JobPostingValue PENDING = new JobPostingValue("pending");
    public static final JobPostingValue INTERNAL = new JobPostingValue("internal");
    public static final JobPostingValue REJECTED = new JobPostingValue("rejected");
    public static final JobPostingValue CLOSED = new JobPostingValue("closed");
    public static final JobPostingValue ARCHIVED = new JobPostingValue("archived");
    public static final JobPostingValue UNMAPPED_VALUE = new JobPostingValue("unmapped_value");
    private static final Map<String, JobPostingValue> values = JobPostingValue.createValuesMap();
    private static final Map<String, JobPostingValueEnum> enums = JobPostingValue.createEnumsMap();
    private final String value;

    private JobPostingValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JobPostingValue of(String value) {
        Class<JobPostingValue> clazz = JobPostingValue.class;
        synchronized (JobPostingValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new JobPostingValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<JobPostingValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JobPostingValue other = (JobPostingValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "JobPostingValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JobPostingValue[] values() {
        Class<JobPostingValue> clazz = JobPostingValue.class;
        synchronized (JobPostingValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new JobPostingValue[0]);
        }
    }

    private static final Map<String, JobPostingValue> createValuesMap() {
        LinkedHashMap<String, JobPostingValue> map = new LinkedHashMap<String, JobPostingValue>();
        map.put("live", LIVE);
        map.put("draft", DRAFT);
        map.put("pending", PENDING);
        map.put("internal", INTERNAL);
        map.put("rejected", REJECTED);
        map.put("closed", CLOSED);
        map.put("archived", ARCHIVED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, JobPostingValueEnum> createEnumsMap() {
        HashMap<String, JobPostingValueEnum> map = new HashMap<String, JobPostingValueEnum>();
        map.put("live", JobPostingValueEnum.LIVE);
        map.put("draft", JobPostingValueEnum.DRAFT);
        map.put("pending", JobPostingValueEnum.PENDING);
        map.put("internal", JobPostingValueEnum.INTERNAL);
        map.put("rejected", JobPostingValueEnum.REJECTED);
        map.put("closed", JobPostingValueEnum.CLOSED);
        map.put("archived", JobPostingValueEnum.ARCHIVED);
        map.put("unmapped_value", JobPostingValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum JobPostingValueEnum {
        LIVE("live"),
        DRAFT("draft"),
        PENDING("pending"),
        INTERNAL("internal"),
        REJECTED("rejected"),
        CLOSED("closed"),
        ARCHIVED("archived"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private JobPostingValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<JobPostingValue> {
        protected _Deserializer() {
            super(JobPostingValue.class);
        }

        public JobPostingValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return JobPostingValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<JobPostingValue> {
        protected _Serializer() {
            super(JobPostingValue.class);
        }

        public void serialize(JobPostingValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

