/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import org.openapitools.jackson.nullable.JsonNullable;

public class MessagingMessageSendRequestDto {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="content")
    private JsonNullable<String> content;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="recipient")
    private JsonNullable<String> recipient;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="sender")
    private JsonNullable<String> sender;

    @JsonCreator
    public MessagingMessageSendRequestDto(@JsonProperty(value="content") JsonNullable<String> content, @JsonProperty(value="recipient") JsonNullable<String> recipient, @JsonProperty(value="sender") JsonNullable<String> sender) {
        Utils.checkNotNull(content, "content");
        Utils.checkNotNull(recipient, "recipient");
        Utils.checkNotNull(sender, "sender");
        this.content = content;
        this.recipient = recipient;
        this.sender = sender;
    }

    public MessagingMessageSendRequestDto() {
        this((JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<String> content() {
        return this.content;
    }

    @JsonIgnore
    public JsonNullable<String> recipient() {
        return this.recipient;
    }

    @JsonIgnore
    public JsonNullable<String> sender() {
        return this.sender;
    }

    public static Builder builder() {
        return new Builder();
    }

    public MessagingMessageSendRequestDto withContent(String content) {
        Utils.checkNotNull(content, "content");
        this.content = JsonNullable.of((Object)content);
        return this;
    }

    public MessagingMessageSendRequestDto withContent(JsonNullable<String> content) {
        Utils.checkNotNull(content, "content");
        this.content = content;
        return this;
    }

    public MessagingMessageSendRequestDto withRecipient(String recipient) {
        Utils.checkNotNull(recipient, "recipient");
        this.recipient = JsonNullable.of((Object)recipient);
        return this;
    }

    public MessagingMessageSendRequestDto withRecipient(JsonNullable<String> recipient) {
        Utils.checkNotNull(recipient, "recipient");
        this.recipient = recipient;
        return this;
    }

    public MessagingMessageSendRequestDto withSender(String sender) {
        Utils.checkNotNull(sender, "sender");
        this.sender = JsonNullable.of((Object)sender);
        return this;
    }

    public MessagingMessageSendRequestDto withSender(JsonNullable<String> sender) {
        Utils.checkNotNull(sender, "sender");
        this.sender = sender;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessagingMessageSendRequestDto other = (MessagingMessageSendRequestDto)o;
        return Utils.enhancedDeepEquals(this.content, other.content) && Utils.enhancedDeepEquals(this.recipient, other.recipient) && Utils.enhancedDeepEquals(this.sender, other.sender);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.content, this.recipient, this.sender);
    }

    public String toString() {
        return Utils.toString(MessagingMessageSendRequestDto.class, "content", this.content, "recipient", this.recipient, "sender", this.sender);
    }

    public static final class Builder {
        private JsonNullable<String> content = JsonNullable.undefined();
        private JsonNullable<String> recipient = JsonNullable.undefined();
        private JsonNullable<String> sender = JsonNullable.undefined();

        private Builder() {
        }

        public Builder content(String content) {
            Utils.checkNotNull(content, "content");
            this.content = JsonNullable.of((Object)content);
            return this;
        }

        public Builder content(JsonNullable<String> content) {
            Utils.checkNotNull(content, "content");
            this.content = content;
            return this;
        }

        public Builder recipient(String recipient) {
            Utils.checkNotNull(recipient, "recipient");
            this.recipient = JsonNullable.of((Object)recipient);
            return this;
        }

        public Builder recipient(JsonNullable<String> recipient) {
            Utils.checkNotNull(recipient, "recipient");
            this.recipient = recipient;
            return this;
        }

        public Builder sender(String sender) {
            Utils.checkNotNull(sender, "sender");
            this.sender = JsonNullable.of((Object)sender);
            return this;
        }

        public Builder sender(JsonNullable<String> sender) {
            Utils.checkNotNull(sender, "sender");
            this.sender = sender;
            return this;
        }

        public MessagingMessageSendRequestDto build() {
            return new MessagingMessageSendRequestDto(this.content, this.recipient, this.sender);
        }
    }
}

