/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

package com.stackone.stackone_client_java;

import com.stackone.stackone_client_java.utils.HTTPClient;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Hook.SdkInitData;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.SpeakeasyHTTPClient;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

/**
 * Accounting: The documentation for the StackOne Unified API - ACCOUNTING
 */
public class StackOne {
    private static final Headers _headers = Headers.EMPTY;


    /**
     * SERVERS contains the list of server urls available to the SDK.
     */
    public static final String[] SERVERS = {

        "https://api.stackone.com",
    };

    /**
     * Generate connection session tokens or auth URLs to allow your customers to connect their accounts.
     */
    private final ConnectSessions connectSessions;

    /**
     * Chart of accounts.
     */
    private final Accounts accounts;

    /**
     * API requests and response logs.
     */
    private final RequestLogs requestLogs;

    /**
     * Retrieve metadata for connectors.
     */
    private final Connectors connectors;

    /**
     * Model Context Protocol endpoint.
     */
    private final Mcp mcp;

    /**
     * Routing API requests through StackOne directly to the underlying provider.
     */
    private final Proxy proxy;

    /**
     * Retrieve Actions metadata and definitions.
     */
    private final Actions actions;


    private final Hris hris;


    private final Ats ats;


    private final Crm crm;


    private final Iam iam;


    private final Marketing marketing;


    private final Lms lms;


    private final Ticketing ticketing;


    private final Documents documents;


    private final Screening screening;


    private final Messaging messaging;


    private final Accounting accounting;

    /**
     * Generate connection session tokens or auth URLs to allow your customers to connect their accounts.
     */
    public ConnectSessions connectSessions() {
        return connectSessions;
    }

    /**
     * Chart of accounts.
     */
    public Accounts accounts() {
        return accounts;
    }

    /**
     * API requests and response logs.
     */
    public RequestLogs requestLogs() {
        return requestLogs;
    }

    /**
     * Retrieve metadata for connectors.
     */
    public Connectors connectors() {
        return connectors;
    }

    /**
     * Model Context Protocol endpoint.
     */
    public Mcp mcp() {
        return mcp;
    }

    /**
     * Routing API requests through StackOne directly to the underlying provider.
     */
    public Proxy proxy() {
        return proxy;
    }

    /**
     * Retrieve Actions metadata and definitions.
     */
    public Actions actions() {
        return actions;
    }


    public Hris hris() {
        return hris;
    }


    public Ats ats() {
        return ats;
    }


    public Crm crm() {
        return crm;
    }


    public Iam iam() {
        return iam;
    }


    public Marketing marketing() {
        return marketing;
    }


    public Lms lms() {
        return lms;
    }


    public Ticketing ticketing() {
        return ticketing;
    }


    public Documents documents() {
        return documents;
    }


    public Screening screening() {
        return screening;
    }


    public Messaging messaging() {
        return messaging;
    }


    public Accounting accounting() {
        return accounting;
    }
    private final AsyncStackOne asyncSDK;

    /**
     * The Builder class allows the configuration of a new instance of the SDK.
     */
    public static class Builder {

        private final SDKConfiguration sdkConfiguration = new SDKConfiguration();
        private String serverUrl;
        private String server;
        

        private Builder() {
        }

        /**
         * Allows the default HTTP client to be overridden with a custom implementation.
         *
         * @param client The HTTP client to use for all requests.
         * @return The builder instance.
         */
        public Builder client(HTTPClient client) {
            this.sdkConfiguration.setClient(client);
            return this;
        }
        
        /**
         * Configures the SDK to use the provided security details.
         *
         * @param security The security details to use for all requests. Can be {@code null}.
         * @return The builder instance.
         */
        public Builder security(com.stackone.stackone_client_java.models.components.Security security) {
            this.sdkConfiguration.setSecuritySource(SecuritySource.of(security));
            return this;
        }

        /**
         * Configures the SDK to use a custom security source.
         *
         * @param securitySource The security source to use for all requests.
         * @return The builder instance.
         */
        public Builder securitySource(SecuritySource securitySource) {
            Utils.checkNotNull(securitySource, "securitySource");
            this.sdkConfiguration.setSecuritySource(securitySource);
            return this;
        }
        
        /**
         * Overrides the default server URL.
         *
         * @param serverUrl The server URL to use for all requests.
         * @return The builder instance.
         */
        public Builder serverURL(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        /**
         * Overrides the default server URL with a templated URL populated with the provided parameters.
         *
         * @param serverUrl The server URL to use for all requests.
         * @param params The parameters to use when templating the URL.
         * @return The builder instance.
         */
        public Builder serverURL(String serverUrl, Map<String, String> params) {
            this.serverUrl = Utils.templateUrl(serverUrl, params);
            return this;
        }
        
        /**
         * Overrides the default server by index.
         *
         * @param serverIdx The server to use for all requests.
         * @return The builder instance.
         */
        public Builder serverIndex(int serverIdx) {
            this.sdkConfiguration.setServerIdx(serverIdx);
            this.serverUrl= SERVERS[serverIdx];
            return this;
        }
        
        /**
         * Overrides the default configuration for retries
         *
         * @param retryConfig The retry configuration to use for all requests.
         * @return The builder instance.
         */
        public Builder retryConfig(RetryConfig retryConfig) {
            this.sdkConfiguration.setRetryConfig(Optional.of(retryConfig));
            return this;
        }

        /**
         * Enables debug logging for HTTP requests and responses, including JSON body content.
         * <p>
         * Convenience method that calls {@link HTTPClient#enableDebugLogging(boolean)}.
         * {@link SpeakeasyHTTPClient} honors this setting. If you are using a custom HTTP client,
         * it is up to the custom client to honor this setting.
         * </p>
         *
         * @param enabled Whether to enable debug logging.
         * @return The builder instance.
         */
        public Builder enableHTTPDebugLogging(boolean enabled) {
            this.sdkConfiguration.client().enableDebugLogging(enabled);
            return this;
        }

        // Visible for testing, may be accessed via reflection in tests
        Builder _hooks(com.stackone.stackone_client_java.utils.Hooks hooks) {
            sdkConfiguration.setHooks(hooks);  
            return this;  
        }
        
        // Visible for testing, may be accessed via reflection in tests
        Builder _hooks(Consumer<? super com.stackone.stackone_client_java.utils.Hooks> consumer) {
            consumer.accept(sdkConfiguration.hooks());
            return this;    
        }

        /**
         * Builds a new instance of the SDK.
         *
         * @return The SDK instance.
         */
        public StackOne build() {
            if (serverUrl == null || serverUrl.isBlank()) {
                serverUrl = SERVERS[0];
                sdkConfiguration.setServerIdx(0);
            }
            sdkConfiguration.setServerUrl(serverUrl);
            return new StackOne(sdkConfiguration);
        }
    }

    /**
     * Get a new instance of the SDK builder to configure a new instance of the SDK.
     *
     * @return The SDK builder instance.
     */
    public static Builder builder() {
        return new Builder();
    }

    public StackOne(SDKConfiguration sdkConfiguration) {
        sdkConfiguration.initialize();
        this.connectSessions = new ConnectSessions(sdkConfiguration);
        this.accounts = new Accounts(sdkConfiguration);
        this.requestLogs = new RequestLogs(sdkConfiguration);
        this.connectors = new Connectors(sdkConfiguration);
        this.mcp = new Mcp(sdkConfiguration);
        this.proxy = new Proxy(sdkConfiguration);
        this.actions = new Actions(sdkConfiguration);
        this.hris = new Hris(sdkConfiguration);
        this.ats = new Ats(sdkConfiguration);
        this.crm = new Crm(sdkConfiguration);
        this.iam = new Iam(sdkConfiguration);
        this.marketing = new Marketing(sdkConfiguration);
        this.lms = new Lms(sdkConfiguration);
        this.ticketing = new Ticketing(sdkConfiguration);
        this.documents = new Documents(sdkConfiguration);
        this.screening = new Screening(sdkConfiguration);
        this.messaging = new Messaging(sdkConfiguration);
        this.accounting = new Accounting(sdkConfiguration);
        SdkInitData data = sdkConfiguration.hooks().sdkInit(
                new SdkInitData(
                        sdkConfiguration.resolvedServerUrl(), 
                        sdkConfiguration.client()));
        sdkConfiguration.setServerUrl(data.baseUrl());
        sdkConfiguration.setClient(data.client());
        this.asyncSDK = new AsyncStackOne(this, sdkConfiguration);
    }

    /**
     * Switches to the async SDK.
     * 
     * @return The async SDK
     */
    public AsyncStackOne async() {
        return asyncSDK;
    }

}
