/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * AccountingAccountResultValue
 * 
 * <p>Type of account
 */
public class AccountingAccountResultValue {

    public static final AccountingAccountResultValue ASSET = new AccountingAccountResultValue("asset");
    public static final AccountingAccountResultValue LIABILITY = new AccountingAccountResultValue("liability");
    public static final AccountingAccountResultValue EQUITY = new AccountingAccountResultValue("equity");
    public static final AccountingAccountResultValue REVENUE = new AccountingAccountResultValue("revenue");
    public static final AccountingAccountResultValue EXPENSE = new AccountingAccountResultValue("expense");
    public static final AccountingAccountResultValue UNMAPPED_VALUE = new AccountingAccountResultValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, AccountingAccountResultValue> values = createValuesMap();
    private static final Map<String, AccountingAccountResultValueEnum> enums = createEnumsMap();

    private final String value;

    private AccountingAccountResultValue(String value) {
        this.value = value;
    }

    /**
     * Returns a AccountingAccountResultValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as AccountingAccountResultValue
     */ 
    @JsonCreator
    public static AccountingAccountResultValue of(String value) {
        synchronized (AccountingAccountResultValue.class) {
            return values.computeIfAbsent(value, v -> new AccountingAccountResultValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<AccountingAccountResultValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        AccountingAccountResultValue other = (AccountingAccountResultValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "AccountingAccountResultValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static AccountingAccountResultValue[] values() {
        synchronized (AccountingAccountResultValue.class) {
            return values.values().toArray(new AccountingAccountResultValue[] {});
        }
    }

    private static final Map<String, AccountingAccountResultValue> createValuesMap() {
        Map<String, AccountingAccountResultValue> map = new LinkedHashMap<>();
        map.put("asset", ASSET);
        map.put("liability", LIABILITY);
        map.put("equity", EQUITY);
        map.put("revenue", REVENUE);
        map.put("expense", EXPENSE);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, AccountingAccountResultValueEnum> createEnumsMap() {
        Map<String, AccountingAccountResultValueEnum> map = new HashMap<>();
        map.put("asset", AccountingAccountResultValueEnum.ASSET);
        map.put("liability", AccountingAccountResultValueEnum.LIABILITY);
        map.put("equity", AccountingAccountResultValueEnum.EQUITY);
        map.put("revenue", AccountingAccountResultValueEnum.REVENUE);
        map.put("expense", AccountingAccountResultValueEnum.EXPENSE);
        map.put("unmapped_value", AccountingAccountResultValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum AccountingAccountResultValueEnum {

        ASSET("asset"),
        LIABILITY("liability"),
        EQUITY("equity"),
        REVENUE("revenue"),
        EXPENSE("expense"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private AccountingAccountResultValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

