/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.stackone.stackone_client_java.utils.LazySingletonValue;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Double;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class ActionSearchDto {
    /**
     * Search query for finding connector actions
     */
    @JsonProperty("query")
    private String query;

    /**
     * Filter by connector key
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("connector")
    private Optional<String> connector;

    /**
     * Number of results to return
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("top_k")
    private Optional<Double> topK;

    @JsonCreator
    public ActionSearchDto(
            @JsonProperty("query") String query,
            @JsonProperty("connector") Optional<String> connector,
            @JsonProperty("top_k") Optional<Double> topK) {
        Utils.checkNotNull(query, "query");
        Utils.checkNotNull(connector, "connector");
        Utils.checkNotNull(topK, "topK");
        this.query = query;
        this.connector = connector;
        this.topK = topK;
    }
    
    public ActionSearchDto(
            String query) {
        this(query, Optional.empty(), Optional.empty());
    }

    /**
     * Search query for finding connector actions
     */
    @JsonIgnore
    public String query() {
        return query;
    }

    /**
     * Filter by connector key
     */
    @JsonIgnore
    public Optional<String> connector() {
        return connector;
    }

    /**
     * Number of results to return
     */
    @JsonIgnore
    public Optional<Double> topK() {
        return topK;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Search query for finding connector actions
     */
    public ActionSearchDto withQuery(String query) {
        Utils.checkNotNull(query, "query");
        this.query = query;
        return this;
    }

    /**
     * Filter by connector key
     */
    public ActionSearchDto withConnector(String connector) {
        Utils.checkNotNull(connector, "connector");
        this.connector = Optional.ofNullable(connector);
        return this;
    }


    /**
     * Filter by connector key
     */
    public ActionSearchDto withConnector(Optional<String> connector) {
        Utils.checkNotNull(connector, "connector");
        this.connector = connector;
        return this;
    }

    /**
     * Number of results to return
     */
    public ActionSearchDto withTopK(double topK) {
        Utils.checkNotNull(topK, "topK");
        this.topK = Optional.ofNullable(topK);
        return this;
    }


    /**
     * Number of results to return
     */
    public ActionSearchDto withTopK(Optional<Double> topK) {
        Utils.checkNotNull(topK, "topK");
        this.topK = topK;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ActionSearchDto other = (ActionSearchDto) o;
        return 
            Utils.enhancedDeepEquals(this.query, other.query) &&
            Utils.enhancedDeepEquals(this.connector, other.connector) &&
            Utils.enhancedDeepEquals(this.topK, other.topK);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            query, connector, topK);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ActionSearchDto.class,
                "query", query,
                "connector", connector,
                "topK", topK);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String query;

        private Optional<String> connector = Optional.empty();

        private Optional<Double> topK;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Search query for finding connector actions
         */
        public Builder query(String query) {
            Utils.checkNotNull(query, "query");
            this.query = query;
            return this;
        }


        /**
         * Filter by connector key
         */
        public Builder connector(String connector) {
            Utils.checkNotNull(connector, "connector");
            this.connector = Optional.ofNullable(connector);
            return this;
        }

        /**
         * Filter by connector key
         */
        public Builder connector(Optional<String> connector) {
            Utils.checkNotNull(connector, "connector");
            this.connector = connector;
            return this;
        }


        /**
         * Number of results to return
         */
        public Builder topK(double topK) {
            Utils.checkNotNull(topK, "topK");
            this.topK = Optional.ofNullable(topK);
            return this;
        }

        /**
         * Number of results to return
         */
        public Builder topK(Optional<Double> topK) {
            Utils.checkNotNull(topK, "topK");
            this.topK = topK;
            return this;
        }

        public ActionSearchDto build() {
            if (topK == null) {
                topK = _SINGLETON_VALUE_TopK.value();
            }

            return new ActionSearchDto(
                query, connector, topK);
        }


        private static final LazySingletonValue<Optional<Double>> _SINGLETON_VALUE_TopK =
                new LazySingletonValue<>(
                        "top_k",
                        "100",
                        new TypeReference<Optional<Double>>() {});
    }
}
