/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * CreateAnswerValue
 * 
 * <p>The type of the answer.
 */
public class CreateAnswerValue {

    public static final CreateAnswerValue SHORT_TEXT = new CreateAnswerValue("short_text");
    public static final CreateAnswerValue LONG_TEXT = new CreateAnswerValue("long_text");
    public static final CreateAnswerValue ATTACHMENT = new CreateAnswerValue("attachment");
    public static final CreateAnswerValue MULTI_SELECT = new CreateAnswerValue("multi_select");
    public static final CreateAnswerValue SINGLE_SELECT = new CreateAnswerValue("single_select");
    public static final CreateAnswerValue BOOLEAN = new CreateAnswerValue("boolean");
    public static final CreateAnswerValue NUMBER = new CreateAnswerValue("number");
    public static final CreateAnswerValue DATE = new CreateAnswerValue("date");
    public static final CreateAnswerValue VIDEO = new CreateAnswerValue("video");
    public static final CreateAnswerValue REFERENCE_CHECK = new CreateAnswerValue("reference_check");
    public static final CreateAnswerValue URL = new CreateAnswerValue("url");
    public static final CreateAnswerValue UNMAPPED_VALUE = new CreateAnswerValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, CreateAnswerValue> values = createValuesMap();
    private static final Map<String, CreateAnswerValueEnum> enums = createEnumsMap();

    private final String value;

    private CreateAnswerValue(String value) {
        this.value = value;
    }

    /**
     * Returns a CreateAnswerValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as CreateAnswerValue
     */ 
    @JsonCreator
    public static CreateAnswerValue of(String value) {
        synchronized (CreateAnswerValue.class) {
            return values.computeIfAbsent(value, v -> new CreateAnswerValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<CreateAnswerValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        CreateAnswerValue other = (CreateAnswerValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "CreateAnswerValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static CreateAnswerValue[] values() {
        synchronized (CreateAnswerValue.class) {
            return values.values().toArray(new CreateAnswerValue[] {});
        }
    }

    private static final Map<String, CreateAnswerValue> createValuesMap() {
        Map<String, CreateAnswerValue> map = new LinkedHashMap<>();
        map.put("short_text", SHORT_TEXT);
        map.put("long_text", LONG_TEXT);
        map.put("attachment", ATTACHMENT);
        map.put("multi_select", MULTI_SELECT);
        map.put("single_select", SINGLE_SELECT);
        map.put("boolean", BOOLEAN);
        map.put("number", NUMBER);
        map.put("date", DATE);
        map.put("video", VIDEO);
        map.put("reference_check", REFERENCE_CHECK);
        map.put("url", URL);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, CreateAnswerValueEnum> createEnumsMap() {
        Map<String, CreateAnswerValueEnum> map = new HashMap<>();
        map.put("short_text", CreateAnswerValueEnum.SHORT_TEXT);
        map.put("long_text", CreateAnswerValueEnum.LONG_TEXT);
        map.put("attachment", CreateAnswerValueEnum.ATTACHMENT);
        map.put("multi_select", CreateAnswerValueEnum.MULTI_SELECT);
        map.put("single_select", CreateAnswerValueEnum.SINGLE_SELECT);
        map.put("boolean", CreateAnswerValueEnum.BOOLEAN);
        map.put("number", CreateAnswerValueEnum.NUMBER);
        map.put("date", CreateAnswerValueEnum.DATE);
        map.put("video", CreateAnswerValueEnum.VIDEO);
        map.put("reference_check", CreateAnswerValueEnum.REFERENCE_CHECK);
        map.put("url", CreateAnswerValueEnum.URL);
        map.put("unmapped_value", CreateAnswerValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum CreateAnswerValueEnum {

        SHORT_TEXT("short_text"),
        LONG_TEXT("long_text"),
        ATTACHMENT("attachment"),
        MULTI_SELECT("multi_select"),
        SINGLE_SELECT("single_select"),
        BOOLEAN("boolean"),
        NUMBER("number"),
        DATE("date"),
        VIDEO("video"),
        REFERENCE_CHECK("reference_check"),
        URL("url"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private CreateAnswerValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

