/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * CreateMessageValue
 * 
 * <p>The unified message type.
 */
public class CreateMessageValue {

    public static final CreateMessageValue EMAIL = new CreateMessageValue("email");
    public static final CreateMessageValue SMS = new CreateMessageValue("sms");
    public static final CreateMessageValue PUSH = new CreateMessageValue("push");
    public static final CreateMessageValue WEB_PUSH = new CreateMessageValue("web_push");
    public static final CreateMessageValue IOS_PUSH = new CreateMessageValue("ios_push");
    public static final CreateMessageValue ANDROID_PUSH = new CreateMessageValue("android_push");
    public static final CreateMessageValue APP_PUSH = new CreateMessageValue("app_push");
    public static final CreateMessageValue OMNI_CHANNEL = new CreateMessageValue("omni_channel");
    public static final CreateMessageValue CONTENT_BLOCK = new CreateMessageValue("content_block");
    public static final CreateMessageValue IN_APP = new CreateMessageValue("in_app");
    public static final CreateMessageValue UNKNOWN = new CreateMessageValue("unknown");
    public static final CreateMessageValue UNMAPPED_VALUE = new CreateMessageValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, CreateMessageValue> values = createValuesMap();
    private static final Map<String, CreateMessageValueEnum> enums = createEnumsMap();

    private final String value;

    private CreateMessageValue(String value) {
        this.value = value;
    }

    /**
     * Returns a CreateMessageValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as CreateMessageValue
     */ 
    @JsonCreator
    public static CreateMessageValue of(String value) {
        synchronized (CreateMessageValue.class) {
            return values.computeIfAbsent(value, v -> new CreateMessageValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<CreateMessageValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        CreateMessageValue other = (CreateMessageValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "CreateMessageValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static CreateMessageValue[] values() {
        synchronized (CreateMessageValue.class) {
            return values.values().toArray(new CreateMessageValue[] {});
        }
    }

    private static final Map<String, CreateMessageValue> createValuesMap() {
        Map<String, CreateMessageValue> map = new LinkedHashMap<>();
        map.put("email", EMAIL);
        map.put("sms", SMS);
        map.put("push", PUSH);
        map.put("web_push", WEB_PUSH);
        map.put("ios_push", IOS_PUSH);
        map.put("android_push", ANDROID_PUSH);
        map.put("app_push", APP_PUSH);
        map.put("omni_channel", OMNI_CHANNEL);
        map.put("content_block", CONTENT_BLOCK);
        map.put("in_app", IN_APP);
        map.put("unknown", UNKNOWN);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, CreateMessageValueEnum> createEnumsMap() {
        Map<String, CreateMessageValueEnum> map = new HashMap<>();
        map.put("email", CreateMessageValueEnum.EMAIL);
        map.put("sms", CreateMessageValueEnum.SMS);
        map.put("push", CreateMessageValueEnum.PUSH);
        map.put("web_push", CreateMessageValueEnum.WEB_PUSH);
        map.put("ios_push", CreateMessageValueEnum.IOS_PUSH);
        map.put("android_push", CreateMessageValueEnum.ANDROID_PUSH);
        map.put("app_push", CreateMessageValueEnum.APP_PUSH);
        map.put("omni_channel", CreateMessageValueEnum.OMNI_CHANNEL);
        map.put("content_block", CreateMessageValueEnum.CONTENT_BLOCK);
        map.put("in_app", CreateMessageValueEnum.IN_APP);
        map.put("unknown", CreateMessageValueEnum.UNKNOWN);
        map.put("unmapped_value", CreateMessageValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum CreateMessageValueEnum {

        EMAIL("email"),
        SMS("sms"),
        PUSH("push"),
        WEB_PUSH("web_push"),
        IOS_PUSH("ios_push"),
        ANDROID_PUSH("android_push"),
        APP_PUSH("app_push"),
        OMNI_CHANNEL("omni_channel"),
        CONTENT_BLOCK("content_block"),
        IN_APP("in_app"),
        UNKNOWN("unknown"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private CreateMessageValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

