/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
public class IamRoleValue {

    public static final IamRoleValue ADMIN = new IamRoleValue("admin");
    public static final IamRoleValue VIEWER = new IamRoleValue("viewer");
    public static final IamRoleValue EDITOR = new IamRoleValue("editor");
    public static final IamRoleValue BASIC = new IamRoleValue("basic");
    public static final IamRoleValue GUEST = new IamRoleValue("guest");
    public static final IamRoleValue UNASSIGNED = new IamRoleValue("unassigned");
    public static final IamRoleValue RESTRICTED = new IamRoleValue("restricted");
    public static final IamRoleValue UNMAPPED_VALUE = new IamRoleValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, IamRoleValue> values = createValuesMap();
    private static final Map<String, IamRoleValueEnum> enums = createEnumsMap();

    private final String value;

    private IamRoleValue(String value) {
        this.value = value;
    }

    /**
     * Returns a IamRoleValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as IamRoleValue
     */ 
    @JsonCreator
    public static IamRoleValue of(String value) {
        synchronized (IamRoleValue.class) {
            return values.computeIfAbsent(value, v -> new IamRoleValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<IamRoleValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        IamRoleValue other = (IamRoleValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "IamRoleValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static IamRoleValue[] values() {
        synchronized (IamRoleValue.class) {
            return values.values().toArray(new IamRoleValue[] {});
        }
    }

    private static final Map<String, IamRoleValue> createValuesMap() {
        Map<String, IamRoleValue> map = new LinkedHashMap<>();
        map.put("admin", ADMIN);
        map.put("viewer", VIEWER);
        map.put("editor", EDITOR);
        map.put("basic", BASIC);
        map.put("guest", GUEST);
        map.put("unassigned", UNASSIGNED);
        map.put("restricted", RESTRICTED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, IamRoleValueEnum> createEnumsMap() {
        Map<String, IamRoleValueEnum> map = new HashMap<>();
        map.put("admin", IamRoleValueEnum.ADMIN);
        map.put("viewer", IamRoleValueEnum.VIEWER);
        map.put("editor", IamRoleValueEnum.EDITOR);
        map.put("basic", IamRoleValueEnum.BASIC);
        map.put("guest", IamRoleValueEnum.GUEST);
        map.put("unassigned", IamRoleValueEnum.UNASSIGNED);
        map.put("restricted", IamRoleValueEnum.RESTRICTED);
        map.put("unmapped_value", IamRoleValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum IamRoleValueEnum {

        ADMIN("admin"),
        VIEWER("viewer"),
        EDITOR("editor"),
        BASIC("basic"),
        GUEST("guest"),
        UNASSIGNED("unassigned"),
        RESTRICTED("restricted"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private IamRoleValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

