/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * IamUserValue
 * 
 * <p>The status of the user, e.g. whether the user is enabled, has been disabled (eg. by an admin), or is
 * pending (ie: awaiting approval by the user or an admin).
 */
public class IamUserValue {

    public static final IamUserValue ENABLED = new IamUserValue("enabled");
    public static final IamUserValue DISABLED = new IamUserValue("disabled");
    public static final IamUserValue PENDING = new IamUserValue("pending");
    public static final IamUserValue UNMAPPED_VALUE = new IamUserValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, IamUserValue> values = createValuesMap();
    private static final Map<String, IamUserValueEnum> enums = createEnumsMap();

    private final String value;

    private IamUserValue(String value) {
        this.value = value;
    }

    /**
     * Returns a IamUserValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as IamUserValue
     */ 
    @JsonCreator
    public static IamUserValue of(String value) {
        synchronized (IamUserValue.class) {
            return values.computeIfAbsent(value, v -> new IamUserValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<IamUserValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        IamUserValue other = (IamUserValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "IamUserValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static IamUserValue[] values() {
        synchronized (IamUserValue.class) {
            return values.values().toArray(new IamUserValue[] {});
        }
    }

    private static final Map<String, IamUserValue> createValuesMap() {
        Map<String, IamUserValue> map = new LinkedHashMap<>();
        map.put("enabled", ENABLED);
        map.put("disabled", DISABLED);
        map.put("pending", PENDING);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, IamUserValueEnum> createEnumsMap() {
        Map<String, IamUserValueEnum> map = new HashMap<>();
        map.put("enabled", IamUserValueEnum.ENABLED);
        map.put("disabled", IamUserValueEnum.DISABLED);
        map.put("pending", IamUserValueEnum.PENDING);
        map.put("unmapped_value", IamUserValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum IamUserValueEnum {

        ENABLED("enabled"),
        DISABLED("disabled"),
        PENDING("pending"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private IamUserValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

