/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * TicketingReadTicketValue
 * 
 * <p>The priority of the ticket.
 */
public class TicketingReadTicketValue {

    public static final TicketingReadTicketValue LOWEST = new TicketingReadTicketValue("lowest");
    public static final TicketingReadTicketValue LOW = new TicketingReadTicketValue("low");
    public static final TicketingReadTicketValue MEDIUM = new TicketingReadTicketValue("medium");
    public static final TicketingReadTicketValue HIGH = new TicketingReadTicketValue("high");
    public static final TicketingReadTicketValue HIGHEST = new TicketingReadTicketValue("highest");
    public static final TicketingReadTicketValue UNMAPPED_VALUE = new TicketingReadTicketValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, TicketingReadTicketValue> values = createValuesMap();
    private static final Map<String, TicketingReadTicketValueEnum> enums = createEnumsMap();

    private final String value;

    private TicketingReadTicketValue(String value) {
        this.value = value;
    }

    /**
     * Returns a TicketingReadTicketValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as TicketingReadTicketValue
     */ 
    @JsonCreator
    public static TicketingReadTicketValue of(String value) {
        synchronized (TicketingReadTicketValue.class) {
            return values.computeIfAbsent(value, v -> new TicketingReadTicketValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<TicketingReadTicketValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        TicketingReadTicketValue other = (TicketingReadTicketValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "TicketingReadTicketValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static TicketingReadTicketValue[] values() {
        synchronized (TicketingReadTicketValue.class) {
            return values.values().toArray(new TicketingReadTicketValue[] {});
        }
    }

    private static final Map<String, TicketingReadTicketValue> createValuesMap() {
        Map<String, TicketingReadTicketValue> map = new LinkedHashMap<>();
        map.put("lowest", LOWEST);
        map.put("low", LOW);
        map.put("medium", MEDIUM);
        map.put("high", HIGH);
        map.put("highest", HIGHEST);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, TicketingReadTicketValueEnum> createEnumsMap() {
        Map<String, TicketingReadTicketValueEnum> map = new HashMap<>();
        map.put("lowest", TicketingReadTicketValueEnum.LOWEST);
        map.put("low", TicketingReadTicketValueEnum.LOW);
        map.put("medium", TicketingReadTicketValueEnum.MEDIUM);
        map.put("high", TicketingReadTicketValueEnum.HIGH);
        map.put("highest", TicketingReadTicketValueEnum.HIGHEST);
        map.put("unmapped_value", TicketingReadTicketValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum TicketingReadTicketValueEnum {

        LOWEST("lowest"),
        LOW("low"),
        MEDIUM("medium"),
        HIGH("high"),
        HIGHEST("highest"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private TicketingReadTicketValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

