/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
public class WorkEligibilityValue {

    public static final WorkEligibilityValue VISA = new WorkEligibilityValue("visa");
    public static final WorkEligibilityValue PASSPORT = new WorkEligibilityValue("passport");
    public static final WorkEligibilityValue DRIVER_LICENSE = new WorkEligibilityValue("driver_license");
    public static final WorkEligibilityValue BIRTH_CERTIFICATE = new WorkEligibilityValue("birth_certificate");
    public static final WorkEligibilityValue OTHER = new WorkEligibilityValue("other");
    public static final WorkEligibilityValue UNMAPPED_VALUE = new WorkEligibilityValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, WorkEligibilityValue> values = createValuesMap();
    private static final Map<String, WorkEligibilityValueEnum> enums = createEnumsMap();

    private final String value;

    private WorkEligibilityValue(String value) {
        this.value = value;
    }

    /**
     * Returns a WorkEligibilityValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as WorkEligibilityValue
     */ 
    @JsonCreator
    public static WorkEligibilityValue of(String value) {
        synchronized (WorkEligibilityValue.class) {
            return values.computeIfAbsent(value, v -> new WorkEligibilityValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<WorkEligibilityValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        WorkEligibilityValue other = (WorkEligibilityValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "WorkEligibilityValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static WorkEligibilityValue[] values() {
        synchronized (WorkEligibilityValue.class) {
            return values.values().toArray(new WorkEligibilityValue[] {});
        }
    }

    private static final Map<String, WorkEligibilityValue> createValuesMap() {
        Map<String, WorkEligibilityValue> map = new LinkedHashMap<>();
        map.put("visa", VISA);
        map.put("passport", PASSPORT);
        map.put("driver_license", DRIVER_LICENSE);
        map.put("birth_certificate", BIRTH_CERTIFICATE);
        map.put("other", OTHER);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, WorkEligibilityValueEnum> createEnumsMap() {
        Map<String, WorkEligibilityValueEnum> map = new HashMap<>();
        map.put("visa", WorkEligibilityValueEnum.VISA);
        map.put("passport", WorkEligibilityValueEnum.PASSPORT);
        map.put("driver_license", WorkEligibilityValueEnum.DRIVER_LICENSE);
        map.put("birth_certificate", WorkEligibilityValueEnum.BIRTH_CERTIFICATE);
        map.put("other", WorkEligibilityValueEnum.OTHER);
        map.put("unmapped_value", WorkEligibilityValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum WorkEligibilityValueEnum {

        VISA("visa"),
        PASSPORT("passport"),
        DRIVER_LICENSE("driver_license"),
        BIRTH_CERTIFICATE("birth_certificate"),
        OTHER("other"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private WorkEligibilityValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

