/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import static com.stackone.stackone_client_java.operations.Operations.RequestOperation;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.ProxyRequestBody;
import com.stackone.stackone_client_java.operations.StackoneProxyRequest;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.String;
import java.util.Optional;

public class StackoneProxyRequestRequestBuilder {

    private String xAccountId;
    private Optional<String> prefer = Optional.empty();
    private ProxyRequestBody proxyRequestBody;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers(); 

    public StackoneProxyRequestRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public StackoneProxyRequestRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }
                
    public StackoneProxyRequestRequestBuilder prefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.of(prefer);
        return this;
    }

    public StackoneProxyRequestRequestBuilder prefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public StackoneProxyRequestRequestBuilder proxyRequestBody(ProxyRequestBody proxyRequestBody) {
        Utils.checkNotNull(proxyRequestBody, "proxyRequestBody");
        this.proxyRequestBody = proxyRequestBody;
        return this;
    }
                
    public StackoneProxyRequestRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public StackoneProxyRequestRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }


    private StackoneProxyRequestRequest buildRequest() {

        StackoneProxyRequestRequest request = new StackoneProxyRequestRequest(xAccountId,
            prefer,
            proxyRequestBody);

        return request;
    }

    public StackoneProxyRequestResponse call() {
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        RequestOperation<StackoneProxyRequestRequest, StackoneProxyRequestResponse> operation
              = new StackoneProxyRequest.Sync(sdkConfiguration, options, _headers);
        StackoneProxyRequestRequest request = buildRequest();

        return operation.handleResponse(operation.doRequest(request));
    }
}
