/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ActionBuildResponseDto;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;


public class StackoneBuildActionEmbeddingsResponse implements AsyncResponse {
    /**
     * HTTP response content type for this operation
     */
    private String contentType;

    /**
     * HTTP response status code for this operation
     */
    private int statusCode;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    private HttpResponse<Blob> rawResponse;

    /**
     * Build result
     */
    private Optional<? extends ActionBuildResponseDto> actionBuildResponseDto;


    private Map<String, List<String>> headers;

    @JsonCreator
    public StackoneBuildActionEmbeddingsResponse(
            String contentType,
            int statusCode,
            HttpResponse<Blob> rawResponse,
            Optional<? extends ActionBuildResponseDto> actionBuildResponseDto,
            Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(actionBuildResponseDto, "actionBuildResponseDto");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.actionBuildResponseDto = actionBuildResponseDto;
        this.headers = headers;
    }
    
    public StackoneBuildActionEmbeddingsResponse(
            String contentType,
            int statusCode,
            HttpResponse<Blob> rawResponse,
            Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse,
            Optional.empty(), headers);
    }

    /**
     * HTTP response content type for this operation
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * HTTP response status code for this operation
     */
    @JsonIgnore
    public int statusCode() {
        return statusCode;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return rawResponse;
    }

    /**
     * Build result
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<ActionBuildResponseDto> actionBuildResponseDto() {
        return (Optional<ActionBuildResponseDto>) actionBuildResponseDto;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return headers;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * HTTP response content type for this operation
     */
    public StackoneBuildActionEmbeddingsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * HTTP response status code for this operation
     */
    public StackoneBuildActionEmbeddingsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public StackoneBuildActionEmbeddingsResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    /**
     * Build result
     */
    public StackoneBuildActionEmbeddingsResponse withActionBuildResponseDto(ActionBuildResponseDto actionBuildResponseDto) {
        Utils.checkNotNull(actionBuildResponseDto, "actionBuildResponseDto");
        this.actionBuildResponseDto = Optional.ofNullable(actionBuildResponseDto);
        return this;
    }


    /**
     * Build result
     */
    public StackoneBuildActionEmbeddingsResponse withActionBuildResponseDto(Optional<? extends ActionBuildResponseDto> actionBuildResponseDto) {
        Utils.checkNotNull(actionBuildResponseDto, "actionBuildResponseDto");
        this.actionBuildResponseDto = actionBuildResponseDto;
        return this;
    }

    public StackoneBuildActionEmbeddingsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StackoneBuildActionEmbeddingsResponse other = (StackoneBuildActionEmbeddingsResponse) o;
        return 
            Utils.enhancedDeepEquals(this.contentType, other.contentType) &&
            Utils.enhancedDeepEquals(this.statusCode, other.statusCode) &&
            Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) &&
            Utils.enhancedDeepEquals(this.actionBuildResponseDto, other.actionBuildResponseDto) &&
            Utils.enhancedDeepEquals(this.headers, other.headers);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            contentType, statusCode, rawResponse,
            actionBuildResponseDto, headers);
    }
    
    @Override
    public String toString() {
        return Utils.toString(StackoneBuildActionEmbeddingsResponse.class,
                "contentType", contentType,
                "statusCode", statusCode,
                "rawResponse", rawResponse,
                "actionBuildResponseDto", actionBuildResponseDto,
                "headers", headers);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String contentType;

        private Integer statusCode;

        private HttpResponse<Blob> rawResponse;

        private Optional<? extends ActionBuildResponseDto> actionBuildResponseDto = Optional.empty();

        private Map<String, List<String>> headers;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * HTTP response content type for this operation
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }


        /**
         * HTTP response status code for this operation
         */
        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }


        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }


        /**
         * Build result
         */
        public Builder actionBuildResponseDto(ActionBuildResponseDto actionBuildResponseDto) {
            Utils.checkNotNull(actionBuildResponseDto, "actionBuildResponseDto");
            this.actionBuildResponseDto = Optional.ofNullable(actionBuildResponseDto);
            return this;
        }

        /**
         * Build result
         */
        public Builder actionBuildResponseDto(Optional<? extends ActionBuildResponseDto> actionBuildResponseDto) {
            Utils.checkNotNull(actionBuildResponseDto, "actionBuildResponseDto");
            this.actionBuildResponseDto = actionBuildResponseDto;
            return this;
        }


        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public StackoneBuildActionEmbeddingsResponse build() {

            return new StackoneBuildActionEmbeddingsResponse(
                contentType, statusCode, rawResponse,
                actionBuildResponseDto, headers);
        }

    }
}
