/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;


/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
@JsonDeserialize(using = UpdateEmployeeApiModelValue._Deserializer.class)
@JsonSerialize(using = UpdateEmployeeApiModelValue._Serializer.class)
public class UpdateEmployeeApiModelValue {

    public static final UpdateEmployeeApiModelValue MALE = new UpdateEmployeeApiModelValue("male");
    public static final UpdateEmployeeApiModelValue FEMALE = new UpdateEmployeeApiModelValue("female");
    public static final UpdateEmployeeApiModelValue NON_BINARY = new UpdateEmployeeApiModelValue("non_binary");
    public static final UpdateEmployeeApiModelValue OTHER = new UpdateEmployeeApiModelValue("other");
    public static final UpdateEmployeeApiModelValue NOT_DISCLOSED = new UpdateEmployeeApiModelValue("not_disclosed");
    public static final UpdateEmployeeApiModelValue DIVERSE = new UpdateEmployeeApiModelValue("diverse");
    public static final UpdateEmployeeApiModelValue UNMAPPED_VALUE = new UpdateEmployeeApiModelValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, UpdateEmployeeApiModelValue> values = createValuesMap();
    private static final Map<String, UpdateEmployeeApiModelValueEnum> enums = createEnumsMap();

    private final String value;

    private UpdateEmployeeApiModelValue(String value) {
        this.value = value;
    }

    /**
     * Returns a UpdateEmployeeApiModelValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as UpdateEmployeeApiModelValue
     */ 
    public static UpdateEmployeeApiModelValue of(String value) {
        synchronized (UpdateEmployeeApiModelValue.class) {
            return values.computeIfAbsent(value, v -> new UpdateEmployeeApiModelValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<UpdateEmployeeApiModelValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        UpdateEmployeeApiModelValue other = (UpdateEmployeeApiModelValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "UpdateEmployeeApiModelValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static UpdateEmployeeApiModelValue[] values() {
        synchronized (UpdateEmployeeApiModelValue.class) {
            return values.values().toArray(new UpdateEmployeeApiModelValue[] {});
        }
    }

    private static final Map<String, UpdateEmployeeApiModelValue> createValuesMap() {
        Map<String, UpdateEmployeeApiModelValue> map = new LinkedHashMap<>();
        map.put("male", MALE);
        map.put("female", FEMALE);
        map.put("non_binary", NON_BINARY);
        map.put("other", OTHER);
        map.put("not_disclosed", NOT_DISCLOSED);
        map.put("diverse", DIVERSE);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, UpdateEmployeeApiModelValueEnum> createEnumsMap() {
        Map<String, UpdateEmployeeApiModelValueEnum> map = new HashMap<>();
        map.put("male", UpdateEmployeeApiModelValueEnum.MALE);
        map.put("female", UpdateEmployeeApiModelValueEnum.FEMALE);
        map.put("non_binary", UpdateEmployeeApiModelValueEnum.NON_BINARY);
        map.put("other", UpdateEmployeeApiModelValueEnum.OTHER);
        map.put("not_disclosed", UpdateEmployeeApiModelValueEnum.NOT_DISCLOSED);
        map.put("diverse", UpdateEmployeeApiModelValueEnum.DIVERSE);
        map.put("unmapped_value", UpdateEmployeeApiModelValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<UpdateEmployeeApiModelValue> {

        protected _Serializer() {
            super(UpdateEmployeeApiModelValue.class);
        }

        @Override
        public void serialize(UpdateEmployeeApiModelValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<UpdateEmployeeApiModelValue> {

        protected _Deserializer() {
            super(UpdateEmployeeApiModelValue.class);
        }

        @Override
        public UpdateEmployeeApiModelValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return UpdateEmployeeApiModelValue.of(v);
        }
    }
    
    public enum UpdateEmployeeApiModelValueEnum {

        MALE("male"),
        FEMALE("female"),
        NON_BINARY("non_binary"),
        OTHER("other"),
        NOT_DISCLOSED("not_disclosed"),
        DIVERSE("diverse"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private UpdateEmployeeApiModelValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}
