/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class HrisCreateTimeOffRequestDto {

    /**
     * The employee ID
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("employee_id")
    private JsonNullable<String> employeeId;

    /**
     * The approver ID
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("approver_id")
    private JsonNullable<String> approverId;

    /**
     * The status of the time off request
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("status")
    private JsonNullable<? extends HrisCreateTimeOffRequestDtoStatus> status;

    /**
     * The type of the time off request
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("type")
    @Deprecated
    private JsonNullable<? extends HrisCreateTimeOffRequestDtoType> type;

    /**
     * The start date of the time off request
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("start_date")
    private JsonNullable<OffsetDateTime> startDate;

    /**
     * The end date of the time off request
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("end_date")
    private JsonNullable<OffsetDateTime> endDate;

    /**
     * True if the start of the time off request begins half way through the day
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("start_half_day")
    private JsonNullable<? extends HrisCreateTimeOffRequestDtoStartHalfDay> startHalfDay;

    /**
     * True if the end of the time off request ends half way through the day
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("end_half_day")
    private JsonNullable<? extends HrisCreateTimeOffRequestDtoEndHalfDay> endHalfDay;

    /**
     * The time off policy id associated with this time off request
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("time_off_policy_id")
    private JsonNullable<String> timeOffPolicyId;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("reason")
    private JsonNullable<? extends HrisCreateTimeOffRequestDtoReason> reason;

    /**
     * Value to pass through to the provider
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("passthrough")
    private JsonNullable<? extends Map<String, Object>> passthrough;

    @JsonCreator
    public HrisCreateTimeOffRequestDto(
            @JsonProperty("employee_id") JsonNullable<String> employeeId,
            @JsonProperty("approver_id") JsonNullable<String> approverId,
            @JsonProperty("status") JsonNullable<? extends HrisCreateTimeOffRequestDtoStatus> status,
            @JsonProperty("type") JsonNullable<? extends HrisCreateTimeOffRequestDtoType> type,
            @JsonProperty("start_date") JsonNullable<OffsetDateTime> startDate,
            @JsonProperty("end_date") JsonNullable<OffsetDateTime> endDate,
            @JsonProperty("start_half_day") JsonNullable<? extends HrisCreateTimeOffRequestDtoStartHalfDay> startHalfDay,
            @JsonProperty("end_half_day") JsonNullable<? extends HrisCreateTimeOffRequestDtoEndHalfDay> endHalfDay,
            @JsonProperty("time_off_policy_id") JsonNullable<String> timeOffPolicyId,
            @JsonProperty("reason") JsonNullable<? extends HrisCreateTimeOffRequestDtoReason> reason,
            @JsonProperty("passthrough") JsonNullable<? extends Map<String, Object>> passthrough) {
        Utils.checkNotNull(employeeId, "employeeId");
        Utils.checkNotNull(approverId, "approverId");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(startDate, "startDate");
        Utils.checkNotNull(endDate, "endDate");
        Utils.checkNotNull(startHalfDay, "startHalfDay");
        Utils.checkNotNull(endHalfDay, "endHalfDay");
        Utils.checkNotNull(timeOffPolicyId, "timeOffPolicyId");
        Utils.checkNotNull(reason, "reason");
        Utils.checkNotNull(passthrough, "passthrough");
        this.employeeId = employeeId;
        this.approverId = approverId;
        this.status = status;
        this.type = type;
        this.startDate = startDate;
        this.endDate = endDate;
        this.startHalfDay = startHalfDay;
        this.endHalfDay = endHalfDay;
        this.timeOffPolicyId = timeOffPolicyId;
        this.reason = reason;
        this.passthrough = passthrough;
    }
    
    public HrisCreateTimeOffRequestDto() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The employee ID
     */
    @JsonIgnore
    public JsonNullable<String> employeeId() {
        return employeeId;
    }

    /**
     * The approver ID
     */
    @JsonIgnore
    public JsonNullable<String> approverId() {
        return approverId;
    }

    /**
     * The status of the time off request
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<HrisCreateTimeOffRequestDtoStatus> status() {
        return (JsonNullable<HrisCreateTimeOffRequestDtoStatus>) status;
    }

    /**
     * The type of the time off request
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<HrisCreateTimeOffRequestDtoType> type() {
        return (JsonNullable<HrisCreateTimeOffRequestDtoType>) type;
    }

    /**
     * The start date of the time off request
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> startDate() {
        return startDate;
    }

    /**
     * The end date of the time off request
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> endDate() {
        return endDate;
    }

    /**
     * True if the start of the time off request begins half way through the day
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<HrisCreateTimeOffRequestDtoStartHalfDay> startHalfDay() {
        return (JsonNullable<HrisCreateTimeOffRequestDtoStartHalfDay>) startHalfDay;
    }

    /**
     * True if the end of the time off request ends half way through the day
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<HrisCreateTimeOffRequestDtoEndHalfDay> endHalfDay() {
        return (JsonNullable<HrisCreateTimeOffRequestDtoEndHalfDay>) endHalfDay;
    }

    /**
     * The time off policy id associated with this time off request
     */
    @JsonIgnore
    public JsonNullable<String> timeOffPolicyId() {
        return timeOffPolicyId;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<HrisCreateTimeOffRequestDtoReason> reason() {
        return (JsonNullable<HrisCreateTimeOffRequestDtoReason>) reason;
    }

    /**
     * Value to pass through to the provider
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> passthrough() {
        return (JsonNullable<Map<String, Object>>) passthrough;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * The employee ID
     */
    public HrisCreateTimeOffRequestDto withEmployeeId(String employeeId) {
        Utils.checkNotNull(employeeId, "employeeId");
        this.employeeId = JsonNullable.of(employeeId);
        return this;
    }

    /**
     * The employee ID
     */
    public HrisCreateTimeOffRequestDto withEmployeeId(JsonNullable<String> employeeId) {
        Utils.checkNotNull(employeeId, "employeeId");
        this.employeeId = employeeId;
        return this;
    }

    /**
     * The approver ID
     */
    public HrisCreateTimeOffRequestDto withApproverId(String approverId) {
        Utils.checkNotNull(approverId, "approverId");
        this.approverId = JsonNullable.of(approverId);
        return this;
    }

    /**
     * The approver ID
     */
    public HrisCreateTimeOffRequestDto withApproverId(JsonNullable<String> approverId) {
        Utils.checkNotNull(approverId, "approverId");
        this.approverId = approverId;
        return this;
    }

    /**
     * The status of the time off request
     */
    public HrisCreateTimeOffRequestDto withStatus(HrisCreateTimeOffRequestDtoStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = JsonNullable.of(status);
        return this;
    }

    /**
     * The status of the time off request
     */
    public HrisCreateTimeOffRequestDto withStatus(JsonNullable<? extends HrisCreateTimeOffRequestDtoStatus> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    /**
     * The type of the time off request
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public HrisCreateTimeOffRequestDto withType(HrisCreateTimeOffRequestDtoType type) {
        Utils.checkNotNull(type, "type");
        this.type = JsonNullable.of(type);
        return this;
    }

    /**
     * The type of the time off request
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public HrisCreateTimeOffRequestDto withType(JsonNullable<? extends HrisCreateTimeOffRequestDtoType> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    /**
     * The start date of the time off request
     */
    public HrisCreateTimeOffRequestDto withStartDate(OffsetDateTime startDate) {
        Utils.checkNotNull(startDate, "startDate");
        this.startDate = JsonNullable.of(startDate);
        return this;
    }

    /**
     * The start date of the time off request
     */
    public HrisCreateTimeOffRequestDto withStartDate(JsonNullable<OffsetDateTime> startDate) {
        Utils.checkNotNull(startDate, "startDate");
        this.startDate = startDate;
        return this;
    }

    /**
     * The end date of the time off request
     */
    public HrisCreateTimeOffRequestDto withEndDate(OffsetDateTime endDate) {
        Utils.checkNotNull(endDate, "endDate");
        this.endDate = JsonNullable.of(endDate);
        return this;
    }

    /**
     * The end date of the time off request
     */
    public HrisCreateTimeOffRequestDto withEndDate(JsonNullable<OffsetDateTime> endDate) {
        Utils.checkNotNull(endDate, "endDate");
        this.endDate = endDate;
        return this;
    }

    /**
     * True if the start of the time off request begins half way through the day
     */
    public HrisCreateTimeOffRequestDto withStartHalfDay(HrisCreateTimeOffRequestDtoStartHalfDay startHalfDay) {
        Utils.checkNotNull(startHalfDay, "startHalfDay");
        this.startHalfDay = JsonNullable.of(startHalfDay);
        return this;
    }

    /**
     * True if the start of the time off request begins half way through the day
     */
    public HrisCreateTimeOffRequestDto withStartHalfDay(JsonNullable<? extends HrisCreateTimeOffRequestDtoStartHalfDay> startHalfDay) {
        Utils.checkNotNull(startHalfDay, "startHalfDay");
        this.startHalfDay = startHalfDay;
        return this;
    }

    /**
     * True if the end of the time off request ends half way through the day
     */
    public HrisCreateTimeOffRequestDto withEndHalfDay(HrisCreateTimeOffRequestDtoEndHalfDay endHalfDay) {
        Utils.checkNotNull(endHalfDay, "endHalfDay");
        this.endHalfDay = JsonNullable.of(endHalfDay);
        return this;
    }

    /**
     * True if the end of the time off request ends half way through the day
     */
    public HrisCreateTimeOffRequestDto withEndHalfDay(JsonNullable<? extends HrisCreateTimeOffRequestDtoEndHalfDay> endHalfDay) {
        Utils.checkNotNull(endHalfDay, "endHalfDay");
        this.endHalfDay = endHalfDay;
        return this;
    }

    /**
     * The time off policy id associated with this time off request
     */
    public HrisCreateTimeOffRequestDto withTimeOffPolicyId(String timeOffPolicyId) {
        Utils.checkNotNull(timeOffPolicyId, "timeOffPolicyId");
        this.timeOffPolicyId = JsonNullable.of(timeOffPolicyId);
        return this;
    }

    /**
     * The time off policy id associated with this time off request
     */
    public HrisCreateTimeOffRequestDto withTimeOffPolicyId(JsonNullable<String> timeOffPolicyId) {
        Utils.checkNotNull(timeOffPolicyId, "timeOffPolicyId");
        this.timeOffPolicyId = timeOffPolicyId;
        return this;
    }

    public HrisCreateTimeOffRequestDto withReason(HrisCreateTimeOffRequestDtoReason reason) {
        Utils.checkNotNull(reason, "reason");
        this.reason = JsonNullable.of(reason);
        return this;
    }

    public HrisCreateTimeOffRequestDto withReason(JsonNullable<? extends HrisCreateTimeOffRequestDtoReason> reason) {
        Utils.checkNotNull(reason, "reason");
        this.reason = reason;
        return this;
    }

    /**
     * Value to pass through to the provider
     */
    public HrisCreateTimeOffRequestDto withPassthrough(Map<String, Object> passthrough) {
        Utils.checkNotNull(passthrough, "passthrough");
        this.passthrough = JsonNullable.of(passthrough);
        return this;
    }

    /**
     * Value to pass through to the provider
     */
    public HrisCreateTimeOffRequestDto withPassthrough(JsonNullable<? extends Map<String, Object>> passthrough) {
        Utils.checkNotNull(passthrough, "passthrough");
        this.passthrough = passthrough;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HrisCreateTimeOffRequestDto other = (HrisCreateTimeOffRequestDto) o;
        return 
            Objects.deepEquals(this.employeeId, other.employeeId) &&
            Objects.deepEquals(this.approverId, other.approverId) &&
            Objects.deepEquals(this.status, other.status) &&
            Objects.deepEquals(this.type, other.type) &&
            Objects.deepEquals(this.startDate, other.startDate) &&
            Objects.deepEquals(this.endDate, other.endDate) &&
            Objects.deepEquals(this.startHalfDay, other.startHalfDay) &&
            Objects.deepEquals(this.endHalfDay, other.endHalfDay) &&
            Objects.deepEquals(this.timeOffPolicyId, other.timeOffPolicyId) &&
            Objects.deepEquals(this.reason, other.reason) &&
            Objects.deepEquals(this.passthrough, other.passthrough);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            employeeId,
            approverId,
            status,
            type,
            startDate,
            endDate,
            startHalfDay,
            endHalfDay,
            timeOffPolicyId,
            reason,
            passthrough);
    }
    
    @Override
    public String toString() {
        return Utils.toString(HrisCreateTimeOffRequestDto.class,
                "employeeId", employeeId,
                "approverId", approverId,
                "status", status,
                "type", type,
                "startDate", startDate,
                "endDate", endDate,
                "startHalfDay", startHalfDay,
                "endHalfDay", endHalfDay,
                "timeOffPolicyId", timeOffPolicyId,
                "reason", reason,
                "passthrough", passthrough);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> employeeId = JsonNullable.undefined();
 
        private JsonNullable<String> approverId = JsonNullable.undefined();
 
        private JsonNullable<? extends HrisCreateTimeOffRequestDtoStatus> status = JsonNullable.undefined();
 
        @Deprecated
        private JsonNullable<? extends HrisCreateTimeOffRequestDtoType> type = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> startDate = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> endDate = JsonNullable.undefined();
 
        private JsonNullable<? extends HrisCreateTimeOffRequestDtoStartHalfDay> startHalfDay = JsonNullable.undefined();
 
        private JsonNullable<? extends HrisCreateTimeOffRequestDtoEndHalfDay> endHalfDay = JsonNullable.undefined();
 
        private JsonNullable<String> timeOffPolicyId = JsonNullable.undefined();
 
        private JsonNullable<? extends HrisCreateTimeOffRequestDtoReason> reason = JsonNullable.undefined();
 
        private JsonNullable<? extends Map<String, Object>> passthrough = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The employee ID
         */
        public Builder employeeId(String employeeId) {
            Utils.checkNotNull(employeeId, "employeeId");
            this.employeeId = JsonNullable.of(employeeId);
            return this;
        }

        /**
         * The employee ID
         */
        public Builder employeeId(JsonNullable<String> employeeId) {
            Utils.checkNotNull(employeeId, "employeeId");
            this.employeeId = employeeId;
            return this;
        }

        /**
         * The approver ID
         */
        public Builder approverId(String approverId) {
            Utils.checkNotNull(approverId, "approverId");
            this.approverId = JsonNullable.of(approverId);
            return this;
        }

        /**
         * The approver ID
         */
        public Builder approverId(JsonNullable<String> approverId) {
            Utils.checkNotNull(approverId, "approverId");
            this.approverId = approverId;
            return this;
        }

        /**
         * The status of the time off request
         */
        public Builder status(HrisCreateTimeOffRequestDtoStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = JsonNullable.of(status);
            return this;
        }

        /**
         * The status of the time off request
         */
        public Builder status(JsonNullable<? extends HrisCreateTimeOffRequestDtoStatus> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        /**
         * The type of the time off request
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder type(HrisCreateTimeOffRequestDtoType type) {
            Utils.checkNotNull(type, "type");
            this.type = JsonNullable.of(type);
            return this;
        }

        /**
         * The type of the time off request
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder type(JsonNullable<? extends HrisCreateTimeOffRequestDtoType> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }

        /**
         * The start date of the time off request
         */
        public Builder startDate(OffsetDateTime startDate) {
            Utils.checkNotNull(startDate, "startDate");
            this.startDate = JsonNullable.of(startDate);
            return this;
        }

        /**
         * The start date of the time off request
         */
        public Builder startDate(JsonNullable<OffsetDateTime> startDate) {
            Utils.checkNotNull(startDate, "startDate");
            this.startDate = startDate;
            return this;
        }

        /**
         * The end date of the time off request
         */
        public Builder endDate(OffsetDateTime endDate) {
            Utils.checkNotNull(endDate, "endDate");
            this.endDate = JsonNullable.of(endDate);
            return this;
        }

        /**
         * The end date of the time off request
         */
        public Builder endDate(JsonNullable<OffsetDateTime> endDate) {
            Utils.checkNotNull(endDate, "endDate");
            this.endDate = endDate;
            return this;
        }

        /**
         * True if the start of the time off request begins half way through the day
         */
        public Builder startHalfDay(HrisCreateTimeOffRequestDtoStartHalfDay startHalfDay) {
            Utils.checkNotNull(startHalfDay, "startHalfDay");
            this.startHalfDay = JsonNullable.of(startHalfDay);
            return this;
        }

        /**
         * True if the start of the time off request begins half way through the day
         */
        public Builder startHalfDay(JsonNullable<? extends HrisCreateTimeOffRequestDtoStartHalfDay> startHalfDay) {
            Utils.checkNotNull(startHalfDay, "startHalfDay");
            this.startHalfDay = startHalfDay;
            return this;
        }

        /**
         * True if the end of the time off request ends half way through the day
         */
        public Builder endHalfDay(HrisCreateTimeOffRequestDtoEndHalfDay endHalfDay) {
            Utils.checkNotNull(endHalfDay, "endHalfDay");
            this.endHalfDay = JsonNullable.of(endHalfDay);
            return this;
        }

        /**
         * True if the end of the time off request ends half way through the day
         */
        public Builder endHalfDay(JsonNullable<? extends HrisCreateTimeOffRequestDtoEndHalfDay> endHalfDay) {
            Utils.checkNotNull(endHalfDay, "endHalfDay");
            this.endHalfDay = endHalfDay;
            return this;
        }

        /**
         * The time off policy id associated with this time off request
         */
        public Builder timeOffPolicyId(String timeOffPolicyId) {
            Utils.checkNotNull(timeOffPolicyId, "timeOffPolicyId");
            this.timeOffPolicyId = JsonNullable.of(timeOffPolicyId);
            return this;
        }

        /**
         * The time off policy id associated with this time off request
         */
        public Builder timeOffPolicyId(JsonNullable<String> timeOffPolicyId) {
            Utils.checkNotNull(timeOffPolicyId, "timeOffPolicyId");
            this.timeOffPolicyId = timeOffPolicyId;
            return this;
        }

        public Builder reason(HrisCreateTimeOffRequestDtoReason reason) {
            Utils.checkNotNull(reason, "reason");
            this.reason = JsonNullable.of(reason);
            return this;
        }

        public Builder reason(JsonNullable<? extends HrisCreateTimeOffRequestDtoReason> reason) {
            Utils.checkNotNull(reason, "reason");
            this.reason = reason;
            return this;
        }

        /**
         * Value to pass through to the provider
         */
        public Builder passthrough(Map<String, Object> passthrough) {
            Utils.checkNotNull(passthrough, "passthrough");
            this.passthrough = JsonNullable.of(passthrough);
            return this;
        }

        /**
         * Value to pass through to the provider
         */
        public Builder passthrough(JsonNullable<? extends Map<String, Object>> passthrough) {
            Utils.checkNotNull(passthrough, "passthrough");
            this.passthrough = passthrough;
            return this;
        }
        
        public HrisCreateTimeOffRequestDto build() {
            return new HrisCreateTimeOffRequestDto(
                employeeId,
                approverId,
                status,
                type,
                startDate,
                endDate,
                startHalfDay,
                endHalfDay,
                timeOffPolicyId,
                reason,
                passthrough);
        }
    }
}

