/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ContactsPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;

public class CrmListContactsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends ContactsPaginated> contactsPaginated;
    private Map<String, List<String>> headers;
    private Callable<Optional<CrmListContactsResponse>> next = () -> Optional.empty();

    @JsonCreator
    public CrmListContactsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends ContactsPaginated> contactsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(contactsPaginated, "contactsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.contactsPaginated = contactsPaginated;
        this.headers = headers;
    }

    public CrmListContactsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<ContactsPaginated> contactsPaginated() {
        return this.contactsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public Optional<CrmListContactsResponse> next() throws Exception {
        return this.next.call();
    }

    private CrmListContactsResponse withNext(Callable<Optional<CrmListContactsResponse>> next) {
        this.next = next;
        return this;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public CrmListContactsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public CrmListContactsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public CrmListContactsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public CrmListContactsResponse withContactsPaginated(ContactsPaginated contactsPaginated) {
        Utils.checkNotNull(contactsPaginated, "contactsPaginated");
        this.contactsPaginated = Optional.ofNullable(contactsPaginated);
        return this;
    }

    public CrmListContactsResponse withContactsPaginated(Optional<? extends ContactsPaginated> contactsPaginated) {
        Utils.checkNotNull(contactsPaginated, "contactsPaginated");
        this.contactsPaginated = contactsPaginated;
        return this;
    }

    public CrmListContactsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrmListContactsResponse other = (CrmListContactsResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.contactsPaginated, other.contactsPaginated) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.contactsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(CrmListContactsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "contactsPaginated", this.contactsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private Callable<Optional<CrmListContactsResponse>> next;
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends ContactsPaginated> contactsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder contactsPaginated(ContactsPaginated contactsPaginated) {
            Utils.checkNotNull(contactsPaginated, "contactsPaginated");
            this.contactsPaginated = Optional.ofNullable(contactsPaginated);
            return this;
        }

        public Builder contactsPaginated(Optional<? extends ContactsPaginated> contactsPaginated) {
            Utils.checkNotNull(contactsPaginated, "contactsPaginated");
            this.contactsPaginated = contactsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        @Deprecated
        public Builder next(Callable<Optional<CrmListContactsResponse>> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }

        public CrmListContactsResponse build() {
            return new CrmListContactsResponse(this.contentType, this.statusCode, this.rawResponse, this.contactsPaginated, this.headers).withNext(this.next);
        }
    }
}

