/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.IamPolicyResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class IamGetPolicyResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends IamPolicyResult> iamPolicyResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public IamGetPolicyResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends IamPolicyResult> iamPolicyResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(iamPolicyResult, "iamPolicyResult");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.iamPolicyResult = iamPolicyResult;
        this.headers = headers;
    }

    public IamGetPolicyResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<IamPolicyResult> iamPolicyResult() {
        return this.iamPolicyResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public IamGetPolicyResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public IamGetPolicyResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public IamGetPolicyResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public IamGetPolicyResponse withIamPolicyResult(IamPolicyResult iamPolicyResult) {
        Utils.checkNotNull(iamPolicyResult, "iamPolicyResult");
        this.iamPolicyResult = Optional.ofNullable(iamPolicyResult);
        return this;
    }

    public IamGetPolicyResponse withIamPolicyResult(Optional<? extends IamPolicyResult> iamPolicyResult) {
        Utils.checkNotNull(iamPolicyResult, "iamPolicyResult");
        this.iamPolicyResult = iamPolicyResult;
        return this;
    }

    public IamGetPolicyResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IamGetPolicyResponse other = (IamGetPolicyResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.iamPolicyResult, other.iamPolicyResult) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.iamPolicyResult, this.headers);
    }

    public String toString() {
        return Utils.toString(IamGetPolicyResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "iamPolicyResult", this.iamPolicyResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends IamPolicyResult> iamPolicyResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder iamPolicyResult(IamPolicyResult iamPolicyResult) {
            Utils.checkNotNull(iamPolicyResult, "iamPolicyResult");
            this.iamPolicyResult = Optional.ofNullable(iamPolicyResult);
            return this;
        }

        public Builder iamPolicyResult(Optional<? extends IamPolicyResult> iamPolicyResult) {
            Utils.checkNotNull(iamPolicyResult, "iamPolicyResult");
            this.iamPolicyResult = iamPolicyResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public IamGetPolicyResponse build() {
            return new IamGetPolicyResponse(this.contentType, this.statusCode, this.rawResponse, this.iamPolicyResult, this.headers);
        }
    }
}

