/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

public class HrisDocumentsUploadRequestDto {

    /**
     * The filename of the file to upload
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private JsonNullable<String> name;

    /**
     * The file format of the file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("file_format")
    private JsonNullable<? extends FileFormat> fileFormat;

    /**
     * The base64 encoded content of the file to upload
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("content")
    private JsonNullable<String> content;

    /**
     * The categoryId of the documents
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("category_id")
    private JsonNullable<String> categoryId;

    /**
     * The path for the file to be uploaded to
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("path")
    private JsonNullable<String> path;

    /**
     * The confidentiality level of the file to be uploaded
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("confidential")
    private JsonNullable<? extends Confidential> confidential;

    /**
     * The category to be associated with the file to be uploaded. Id will take precedence over name.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("category")
    private JsonNullable<? extends HrisDocumentsUploadRequestDtoCategory> category;

    @JsonCreator
    public HrisDocumentsUploadRequestDto(
            @JsonProperty("name") JsonNullable<String> name,
            @JsonProperty("file_format") JsonNullable<? extends FileFormat> fileFormat,
            @JsonProperty("content") JsonNullable<String> content,
            @JsonProperty("category_id") JsonNullable<String> categoryId,
            @JsonProperty("path") JsonNullable<String> path,
            @JsonProperty("confidential") JsonNullable<? extends Confidential> confidential,
            @JsonProperty("category") JsonNullable<? extends HrisDocumentsUploadRequestDtoCategory> category) {
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(fileFormat, "fileFormat");
        Utils.checkNotNull(content, "content");
        Utils.checkNotNull(categoryId, "categoryId");
        Utils.checkNotNull(path, "path");
        Utils.checkNotNull(confidential, "confidential");
        Utils.checkNotNull(category, "category");
        this.name = name;
        this.fileFormat = fileFormat;
        this.content = content;
        this.categoryId = categoryId;
        this.path = path;
        this.confidential = confidential;
        this.category = category;
    }
    
    public HrisDocumentsUploadRequestDto() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The filename of the file to upload
     */
    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    /**
     * The file format of the file
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<FileFormat> fileFormat() {
        return (JsonNullable<FileFormat>) fileFormat;
    }

    /**
     * The base64 encoded content of the file to upload
     */
    @JsonIgnore
    public JsonNullable<String> content() {
        return content;
    }

    /**
     * The categoryId of the documents
     */
    @JsonIgnore
    public JsonNullable<String> categoryId() {
        return categoryId;
    }

    /**
     * The path for the file to be uploaded to
     */
    @JsonIgnore
    public JsonNullable<String> path() {
        return path;
    }

    /**
     * The confidentiality level of the file to be uploaded
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Confidential> confidential() {
        return (JsonNullable<Confidential>) confidential;
    }

    /**
     * The category to be associated with the file to be uploaded. Id will take precedence over name.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<HrisDocumentsUploadRequestDtoCategory> category() {
        return (JsonNullable<HrisDocumentsUploadRequestDtoCategory>) category;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The filename of the file to upload
     */
    public HrisDocumentsUploadRequestDto withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    /**
     * The filename of the file to upload
     */
    public HrisDocumentsUploadRequestDto withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * The file format of the file
     */
    public HrisDocumentsUploadRequestDto withFileFormat(FileFormat fileFormat) {
        Utils.checkNotNull(fileFormat, "fileFormat");
        this.fileFormat = JsonNullable.of(fileFormat);
        return this;
    }

    /**
     * The file format of the file
     */
    public HrisDocumentsUploadRequestDto withFileFormat(JsonNullable<? extends FileFormat> fileFormat) {
        Utils.checkNotNull(fileFormat, "fileFormat");
        this.fileFormat = fileFormat;
        return this;
    }

    /**
     * The base64 encoded content of the file to upload
     */
    public HrisDocumentsUploadRequestDto withContent(String content) {
        Utils.checkNotNull(content, "content");
        this.content = JsonNullable.of(content);
        return this;
    }

    /**
     * The base64 encoded content of the file to upload
     */
    public HrisDocumentsUploadRequestDto withContent(JsonNullable<String> content) {
        Utils.checkNotNull(content, "content");
        this.content = content;
        return this;
    }

    /**
     * The categoryId of the documents
     */
    public HrisDocumentsUploadRequestDto withCategoryId(String categoryId) {
        Utils.checkNotNull(categoryId, "categoryId");
        this.categoryId = JsonNullable.of(categoryId);
        return this;
    }

    /**
     * The categoryId of the documents
     */
    public HrisDocumentsUploadRequestDto withCategoryId(JsonNullable<String> categoryId) {
        Utils.checkNotNull(categoryId, "categoryId");
        this.categoryId = categoryId;
        return this;
    }

    /**
     * The path for the file to be uploaded to
     */
    public HrisDocumentsUploadRequestDto withPath(String path) {
        Utils.checkNotNull(path, "path");
        this.path = JsonNullable.of(path);
        return this;
    }

    /**
     * The path for the file to be uploaded to
     */
    public HrisDocumentsUploadRequestDto withPath(JsonNullable<String> path) {
        Utils.checkNotNull(path, "path");
        this.path = path;
        return this;
    }

    /**
     * The confidentiality level of the file to be uploaded
     */
    public HrisDocumentsUploadRequestDto withConfidential(Confidential confidential) {
        Utils.checkNotNull(confidential, "confidential");
        this.confidential = JsonNullable.of(confidential);
        return this;
    }

    /**
     * The confidentiality level of the file to be uploaded
     */
    public HrisDocumentsUploadRequestDto withConfidential(JsonNullable<? extends Confidential> confidential) {
        Utils.checkNotNull(confidential, "confidential");
        this.confidential = confidential;
        return this;
    }

    /**
     * The category to be associated with the file to be uploaded. Id will take precedence over name.
     */
    public HrisDocumentsUploadRequestDto withCategory(HrisDocumentsUploadRequestDtoCategory category) {
        Utils.checkNotNull(category, "category");
        this.category = JsonNullable.of(category);
        return this;
    }

    /**
     * The category to be associated with the file to be uploaded. Id will take precedence over name.
     */
    public HrisDocumentsUploadRequestDto withCategory(JsonNullable<? extends HrisDocumentsUploadRequestDtoCategory> category) {
        Utils.checkNotNull(category, "category");
        this.category = category;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HrisDocumentsUploadRequestDto other = (HrisDocumentsUploadRequestDto) o;
        return 
            Utils.enhancedDeepEquals(this.name, other.name) &&
            Utils.enhancedDeepEquals(this.fileFormat, other.fileFormat) &&
            Utils.enhancedDeepEquals(this.content, other.content) &&
            Utils.enhancedDeepEquals(this.categoryId, other.categoryId) &&
            Utils.enhancedDeepEquals(this.path, other.path) &&
            Utils.enhancedDeepEquals(this.confidential, other.confidential) &&
            Utils.enhancedDeepEquals(this.category, other.category);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            name,
            fileFormat,
            content,
            categoryId,
            path,
            confidential,
            category);
    }
    
    @Override
    public String toString() {
        return Utils.toString(HrisDocumentsUploadRequestDto.class,
                "name", name,
                "fileFormat", fileFormat,
                "content", content,
                "categoryId", categoryId,
                "path", path,
                "confidential", confidential,
                "category", category);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> name = JsonNullable.undefined();
 
        private JsonNullable<? extends FileFormat> fileFormat = JsonNullable.undefined();
 
        private JsonNullable<String> content = JsonNullable.undefined();
 
        private JsonNullable<String> categoryId = JsonNullable.undefined();
 
        private JsonNullable<String> path = JsonNullable.undefined();
 
        private JsonNullable<? extends Confidential> confidential = JsonNullable.undefined();
 
        private JsonNullable<? extends HrisDocumentsUploadRequestDtoCategory> category = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The filename of the file to upload
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        /**
         * The filename of the file to upload
         */
        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        /**
         * The file format of the file
         */
        public Builder fileFormat(FileFormat fileFormat) {
            Utils.checkNotNull(fileFormat, "fileFormat");
            this.fileFormat = JsonNullable.of(fileFormat);
            return this;
        }

        /**
         * The file format of the file
         */
        public Builder fileFormat(JsonNullable<? extends FileFormat> fileFormat) {
            Utils.checkNotNull(fileFormat, "fileFormat");
            this.fileFormat = fileFormat;
            return this;
        }

        /**
         * The base64 encoded content of the file to upload
         */
        public Builder content(String content) {
            Utils.checkNotNull(content, "content");
            this.content = JsonNullable.of(content);
            return this;
        }

        /**
         * The base64 encoded content of the file to upload
         */
        public Builder content(JsonNullable<String> content) {
            Utils.checkNotNull(content, "content");
            this.content = content;
            return this;
        }

        /**
         * The categoryId of the documents
         */
        public Builder categoryId(String categoryId) {
            Utils.checkNotNull(categoryId, "categoryId");
            this.categoryId = JsonNullable.of(categoryId);
            return this;
        }

        /**
         * The categoryId of the documents
         */
        public Builder categoryId(JsonNullable<String> categoryId) {
            Utils.checkNotNull(categoryId, "categoryId");
            this.categoryId = categoryId;
            return this;
        }

        /**
         * The path for the file to be uploaded to
         */
        public Builder path(String path) {
            Utils.checkNotNull(path, "path");
            this.path = JsonNullable.of(path);
            return this;
        }

        /**
         * The path for the file to be uploaded to
         */
        public Builder path(JsonNullable<String> path) {
            Utils.checkNotNull(path, "path");
            this.path = path;
            return this;
        }

        /**
         * The confidentiality level of the file to be uploaded
         */
        public Builder confidential(Confidential confidential) {
            Utils.checkNotNull(confidential, "confidential");
            this.confidential = JsonNullable.of(confidential);
            return this;
        }

        /**
         * The confidentiality level of the file to be uploaded
         */
        public Builder confidential(JsonNullable<? extends Confidential> confidential) {
            Utils.checkNotNull(confidential, "confidential");
            this.confidential = confidential;
            return this;
        }

        /**
         * The category to be associated with the file to be uploaded. Id will take precedence over name.
         */
        public Builder category(HrisDocumentsUploadRequestDtoCategory category) {
            Utils.checkNotNull(category, "category");
            this.category = JsonNullable.of(category);
            return this;
        }

        /**
         * The category to be associated with the file to be uploaded. Id will take precedence over name.
         */
        public Builder category(JsonNullable<? extends HrisDocumentsUploadRequestDtoCategory> category) {
            Utils.checkNotNull(category, "category");
            this.category = category;
            return this;
        }
        
        public HrisDocumentsUploadRequestDto build() {
            return new HrisDocumentsUploadRequestDto(
                name,
                fileFormat,
                content,
                categoryId,
                path,
                confidential,
                category);
        }
    }
}
